/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityControllable;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public abstract class GCCoreEntityAdvanced
extends GCCoreEntityControllable
implements IPacketReceiver {
    protected long ticks = 0L;
    public float currentDamage;
    public int timeSinceHit;
    public int rockDirection;
    public double advancedPositionX;
    public double advancedPositionY;
    public double advancedPositionZ;
    public double advancedYaw;
    public double advancedPitch;
    public int posRotIncrements;
    private boolean lastOnGround;

    public GCCoreEntityAdvanced(World world, double initialSpeed, float yOffset) {
        super(world);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.field_70181_x = initialSpeed;
        this.field_70129_M = yOffset;
    }

    public GCCoreEntityAdvanced(World world, double initialSpeed, float yOffset, double var2, double var4, double var6) {
        this(world, initialSpeed, yOffset);
        this.field_70129_M = yOffset;
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 1.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double var1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * -0.5;
            double var3 = Math.sin((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * -0.5;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u + this.field_70153_n.func_70033_W(), this.field_70161_v + var3);
        }
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.advancedPositionX = x;
            this.advancedPositionY = y;
            this.advancedPositionZ = z;
            this.advancedYaw = yaw;
            this.advancedPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.posRotIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            if (onGround) {
                this.field_70122_E = onGround;
            }
        }
    }

    public void func_70057_ab() {
        this.rockDirection = -this.rockDirection;
        this.timeSinceHit = 10;
        this.currentDamage *= 5.0f;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g) || !this.allowDamageSource(var1)) {
            return true;
        }
        this.rockDirection = -this.rockDirection;
        this.timeSinceHit = 10;
        this.currentDamage += var2 * 10.0f;
        this.func_70018_K();
        if (var1.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)var1.func_76346_g()).field_71075_bZ.field_75098_d) {
            this.currentDamage = 100.0f;
        }
        if (this.currentDamage > 70.0f) {
            if (this.field_70153_n != null) {
                if (this.field_70153_n instanceof EntityPlayerMP) {
                    Object[] toSend2 = new Object[]{0};
                    ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", 22, toSend2));
                }
                this.field_70153_n.func_70078_a((Entity)this);
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.dropItems();
                this.func_70106_y();
            }
        }
        return true;
    }

    public abstract List<ItemStack> getItemsDropped();

    public abstract boolean shouldMove();

    public abstract boolean shouldSpawnParticles();

    public abstract Map<Vector3, Vector3> getParticleMap();

    @SideOnly(value=Side.CLIENT)
    public abstract EntityFX getParticle(Random var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public abstract void tickInAir();

    public abstract void tickOnGround();

    public abstract void onGroundHit();

    public abstract Vector3 getMotionVec();

    public abstract ArrayList<Object> getNetworkedData();

    public abstract int getPacketTickSpacing();

    public abstract double getPacketSendDistance();

    public abstract void readNetworkedData(ByteArrayDataInput var1);

    public abstract boolean allowDamageSource(DamageSource var1);

    public void dropItems() {
        if (this.getItemsDropped() == null) {
            return;
        }
        for (ItemStack item : this.getItemsDropped()) {
            if (item == null) continue;
            this.func_70099_a(item, 0.0f);
        }
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (!(this.field_70153_n == null || this.field_70153_n instanceof EntityPlayer && FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70153_n))) {
            this.posRotIncrements = i + 5;
            this.advancedPositionX = d;
            this.advancedPositionY = d1 + (double)(this.field_70153_n == null ? 1 : 0);
            this.advancedPositionZ = d2;
            this.advancedYaw = f;
            this.advancedPitch = f1;
        }
    }

    public void func_70091_d(double par1, double par3, double par5) {
        if (this.shouldMove()) {
            super.func_70091_d(par1, par3, par5);
        }
    }

    public void func_70071_h_() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        super.func_70071_h_();
        if (!(!this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70153_n))) {
            if (this.posRotIncrements > 0) {
                double x = this.field_70165_t + (this.advancedPositionX - this.field_70165_t) / (double)this.posRotIncrements;
                double y = this.field_70163_u + (this.advancedPositionY - this.field_70163_u) / (double)this.posRotIncrements;
                double z = this.field_70161_v + (this.advancedPositionZ - this.field_70161_v) / (double)this.posRotIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.advancedYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.posRotIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.advancedPitch - (double)this.field_70125_A) / (double)this.posRotIncrements);
                --this.posRotIncrements;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(x, y, z);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        }
        if (this.timeSinceHit > 0) {
            --this.timeSinceHit;
        }
        if (this.currentDamage > 0.0f) {
            this.currentDamage -= 1.0f;
        }
        if (this.shouldSpawnParticles() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles(this.getParticleMap());
        }
        if (this.field_70122_E) {
            this.tickOnGround();
        } else {
            this.tickInAir();
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70159_w = this.getMotionVec().x;
            this.field_70181_x = this.getMotionVec().y;
            this.field_70179_y = this.getMotionVec().z;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && !this.lastOnGround) {
            this.onGroundHit();
        }
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)GCCorePacketEntityUpdate.buildUpdatePacket(this));
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)GCCorePacketEntityUpdate.buildUpdatePacket(this));
        }
        if (!this.field_70170_p.field_72995_K && this.ticks % (long)this.getPacketTickSpacing() == 0L) {
            PacketManager.sendPacketToClients(this.getDescriptionPacket(), this.field_70170_p, new Vector3(this), this.getPacketSendDistance());
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.lastOnGround = this.field_70122_E;
    }

    public Packet getDescriptionPacket() {
        return GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.getNetworkedData());
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.readNetworkedData(dataStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(Map<Vector3, Vector3> points) {
        for (Map.Entry<Vector3, Vector3> vec : points.entrySet()) {
            Vector3 posVec = vec.getKey();
            Vector3 motionVec = vec.getValue();
            this.spawnParticle(this.getParticle(this.field_70146_Z, posVec.x, posVec.y, posVec.z, motionVec.x, motionVec.y, motionVec.z));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(EntityFX fx) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.field_71451_h != null && mc.field_71452_i != null && fx != null) {
            mc.field_71452_i.func_78873_a(fx);
        }
    }
}

