/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntitySolar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.block.BlockTile;

public class GCCoreBlockSolar
extends BlockTile {
    public static final int BASIC_METADATA = 0;
    public static final int ADVANCED_METADATA = 4;
    public static String[] names = new String[]{"basic", "advanced"};
    private Icon[] icons = new Icon[6];

    public GCCoreBlockSolar(int id) {
        super(id, Material.field_76243_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public void func_94332_a(IconRegister par1IconRegister) {
        this.icons[0] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "solar_basic_0");
        this.icons[1] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "solar_basic_1");
        this.icons[2] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "solar_advanced_0");
        this.icons[3] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "solar_advanced_1");
        this.icons[4] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[5] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_power_input");
        this.field_94336_cN = this.icons[0];
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta >= 4) {
            int shiftedMeta = meta -= 4;
            if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
                return this.icons[5];
            }
            if (side == ForgeDirection.UP.ordinal()) {
                return this.icons[2];
            }
            if (side == ForgeDirection.DOWN.ordinal()) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta >= 0) {
            int shiftedMeta = meta += 0;
            if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
                return this.icons[5];
            }
            if (side == ForgeDirection.UP.ordinal()) {
                return this.icons[0];
            }
            if (side == ForgeDirection.DOWN.ordinal()) {
                return this.icons[4];
            }
            return this.icons[1];
        }
        return this.field_94336_cN;
    }

    public boolean func_71850_a_(World world, int x1, int y1, int z1, int side) {
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int blockID = world.func_72798_a(x1 + (y == 2 ? x : 0), y1 + 2, z1 + (y == 2 ? z : 0));
                    if (blockID <= 0 || Block.field_71973_m[blockID].isBlockReplaceable(world, x1 + x, y1 + 2, z1 + z)) continue;
                    return false;
                }
            }
        }
        return new Vector3(x1, y1, z1).clone().modifyPositionFromSide(ForgeDirection.getOrientation((int)side).getOpposite()).getBlockID((IBlockAccess)world) != GCCoreBlocks.dummyBlock.field_71990_ca;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        if (metadata >= 4) {
            world.func_72921_c(x, y, z, 4 + change, 3);
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof GCCoreTileEntitySolar) {
            ((GCCoreTileEntitySolar)tile).onCreate(new Vector3(x, y, z));
        }
    }

    @Override
    public void func_71852_a(World var1, int var2, int var3, int var4, int var5, int var6) {
        TileEntity var9 = var1.func_72796_p(var2, var3, var4);
        if (var9 instanceof GCCoreTileEntitySolar) {
            ((GCCoreTileEntitySolar)var9).onDestroy(var9);
        }
        super.func_71852_a(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 4) {
            original -= 4;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 4) {
            change += 4;
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiSolarPanel, world, x, y, z);
        return true;
    }

    public int func_71899_b(int metadata) {
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int id = this.func_71922_a(world, x, y, z);
        if (id == 0) {
            return null;
        }
        Item item = Item.field_77698_e[id];
        if (item == null) {
            return null;
        }
        int metadata = this.func_71873_h(world, x, y, z);
        return new ItemStack(id, 1, metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 4) {
            return new GCCoreTileEntitySolar(100.0f);
        }
        return new GCCoreTileEntitySolar(50.0f);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }
}

