/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoUnloader;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockCargoLoader
extends GCCoreBlockAdvanced {
    private Icon iconMachineSide;
    private Icon iconInput;
    private Icon iconFrontLoader;
    private Icon iconFrontUnloader;
    private Icon iconItemInput;
    private Icon iconItemOutput;

    public GCCoreBlockCargoLoader(int id) {
        super(id, Material.field_76246_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity != null) {
            if (tileEntity instanceof GCCoreTileEntityCargoLoader) {
                ((GCCoreTileEntityCargoLoader)tileEntity).checkForCargoEntity();
            } else if (tileEntity instanceof GCCoreTileEntityCargoUnloader) {
                ((GCCoreTileEntityCargoUnloader)tileEntity).checkForCargoEntity();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_power_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconFrontLoader = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_cargoloader");
        this.iconFrontUnloader = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_cargounloader");
        this.iconItemInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_item_input");
        this.iconItemOutput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_item_output");
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiCargoLoader, world, x, y, z);
        return true;
    }

    public Icon func_71858_a(int side, int metadata) {
        int shiftedMeta;
        int n = shiftedMeta = metadata >= 4 ? metadata - 4 : metadata;
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (side == shiftedMeta + 2) {
            return this.iconInput;
        }
        if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
            return metadata < 4 ? this.iconItemInput : this.iconItemOutput;
        }
        return metadata < 4 ? this.iconFrontLoader : this.iconFrontUnloader;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < 4) {
            return new GCCoreTileEntityCargoLoader();
        }
        if (metadata < 8) {
            return new GCCoreTileEntityCargoUnloader();
        }
        return null;
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        int shiftedMeta = metadata >= 4 ? metadata - 4 : metadata;
        int change = 0;
        switch (shiftedMeta) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change + (metadata < 4 ? 0 : 4), 3);
        return true;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int metadata = world.func_72805_g(x, y, z);
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change + (metadata < 4 ? 0 : 4), 3);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                int id = world.func_72798_a(x + dX, y, z + dZ);
                if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                world.func_72845_h(x + dX, y, z + dZ);
            }
        }
    }

    public void func_71898_d(World world, int x, int y, int z, int par5) {
        super.func_71898_d(world, x, y, z, par5);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                int id = world.func_72798_a(x + dX, y, z + dZ);
                if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                world.func_72845_h(x + dX, y, z + dZ);
            }
        }
    }
}

