/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTTransformation;
import java.util.ArrayList;
import net.minecraft.util.Vec3;

public class NMTVertex {
    public Vec3 baseVector;
    public Vec3 transformVector;
    public ArrayList<NMTTransformation> transformations;
    public Vec3 baseNormal;
    public Vec3 normal;

    public NMTVertex(float x, float y, float z) {
        this(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    public NMTVertex(Vec3 vector) {
        this.baseVector = vector;
        this.transformVector = Vec3.func_72443_a((double)this.baseVector.field_72450_a, (double)this.baseVector.field_72448_b, (double)this.baseVector.field_72449_c);
        this.transformations = new ArrayList();
        this.baseNormal = null;
        this.normal = null;
    }

    public NMTVertex copyVertex() {
        NMTVertex vert = new NMTVertex((float)this.baseVector.field_72450_a, (float)this.baseVector.field_72448_b, (float)this.baseVector.field_72449_c);
        if (this.normal != null) {
            vert.setNormals(Vec3.func_72443_a((double)this.baseNormal.field_72450_a, (double)this.baseNormal.field_72448_b, (double)this.baseNormal.field_72449_c));
        }
        return vert;
    }

    public void addTransformation(NMTTransformation transformation) {
        this.transformations.add(transformation);
    }

    public void setNormals(Vec3 n) {
        this.normal = n;
        this.baseNormal = Vec3.func_72443_a((double)n.field_72450_a, (double)n.field_72448_b, (double)n.field_72449_c);
    }

    public void applyTransformations() {
        this.transformVector.field_72450_a = this.baseVector.field_72450_a;
        this.transformVector.field_72448_b = this.baseVector.field_72448_b;
        this.transformVector.field_72449_c = this.baseVector.field_72449_c;
        this.normal.field_72450_a = this.baseNormal.field_72450_a;
        this.normal.field_72448_b = this.baseNormal.field_72448_b;
        this.normal.field_72449_c = this.baseNormal.field_72449_c;
        float weight = 0.0f;
        float totalWeight = 0.0f;
        for (int idx = 0; idx < this.transformations.size(); ++idx) {
            NMTVertex tempVert = this.copyVertex();
            weight = this.transformations.get((int)idx).weight;
            totalWeight += weight;
            tempVert = this.transformations.get(idx).doTransformation(tempVert);
            this.transformVector.field_72450_a += tempVert.transformVector.field_72450_a * (double)weight;
            this.transformVector.field_72448_b += tempVert.transformVector.field_72448_b * (double)weight;
            this.transformVector.field_72449_c += tempVert.transformVector.field_72449_c * (double)weight;
            this.normal.field_72450_a = tempVert.normal.field_72450_a * (double)weight;
            this.normal.field_72448_b = tempVert.normal.field_72448_b * (double)weight;
            this.normal.field_72449_c = tempVert.normal.field_72449_c * (double)weight;
        }
        this.transformVector.field_72450_a /= (double)totalWeight;
        this.transformVector.field_72448_b /= (double)totalWeight;
        this.transformVector.field_72449_c /= (double)totalWeight;
        this.normal.field_72450_a /= (double)totalWeight;
        this.normal.field_72448_b /= (double)totalWeight;
        this.normal.field_72449_c /= (double)totalWeight;
    }

    public boolean equals(NMTVertex vertex) {
        if (vertex == this) {
            return true;
        }
        if (vertex == null) {
            return false;
        }
        return this.baseVector.field_72450_a == vertex.baseVector.field_72450_a && this.baseVector.field_72448_b == vertex.baseVector.field_72448_b && this.baseVector.field_72449_c == vertex.baseVector.field_72449_c;
    }
}

