/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTModelVoxel;
import com.overminddl1.mods.NMT.NMTVertex;

public class NMTModelSprite
extends NMTModelVoxel {
    protected int textureW;
    protected int textureH;
    protected int layers;
    protected int layersPerRow;
    protected boolean[] rotations;

    public NMTModelSprite(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d, int texW, int texH, int l, int perRow, boolean rotX, boolean rotY, boolean rotZ) {
        super(nmtmodelrenderer, x, y, z, w, h, d);
        this.textureW = texW;
        this.textureH = texH;
        this.layers = l;
        this.layersPerRow = perRow;
        this.rotations = new boolean[]{rotX, rotY, rotZ};
    }

    public NMTModelSprite(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d, int texW, int texH, int l, int perRow) {
        this(nmtmodelrenderer, x, y, z, w, h, d, texW, texH, l, perRow, false, false, false);
    }

    public NMTModelSprite(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d, int texW, int texH, int l) {
        this(nmtmodelrenderer, x, y, z, w, h, d, texW, texH, l, Math.max(1, (int)Math.floor(nmtmodelrenderer.field_78801_a / (float)texW)));
    }

    public NMTModelSprite(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d, int texW, int texH) {
        this(nmtmodelrenderer, x, y, z, w, h, d, texW, texH, 1);
    }

    public NMTModelSprite(NMTModelRenderer nmtmodelrenderer, float x, float y, float z, float w, float h, float d) {
        this(nmtmodelrenderer, x, y, z, w, h, d, (int)Math.floor(w), (int)Math.floor(h));
    }

    @Override
    public NMTModelSprite create() {
        float x1 = this.xPos;
        float y1 = this.yPos;
        float z1 = this.zPos;
        if (this.renderer.field_78809_i) {
            float[] mMul = this.switchValues(1.0f, 0.0f, 0.0f);
            x1 += this.width * mMul[0];
            y1 += this.height * mMul[1];
            z1 += this.depth * mMul[2];
        }
        this.createSpriteVertices(x1, y1, z1);
        this.createSprite();
        if (this.renderer.field_78809_i ^ this.rotations[0] ^ this.rotations[1] ^ this.rotations[2]) {
            this.flipFaces();
        }
        return this;
    }

    protected void createSpriteVertices(float x, float y, float z) {
        float[] sizes = this.switchValues(this.textureW, this.textureH, this.layers);
        float xS = this.width / sizes[0];
        float yS = this.height / sizes[1];
        float zS = this.depth / sizes[2];
        if (this.renderer.field_78809_i) {
            float[] mMul = this.switchValues(-1.0f, 1.0f, 1.0f);
            xS *= mMul[0];
            yS *= mMul[1];
            zS *= mMul[2];
        }
        for (int idz = 0; idz < this.layers + 1; ++idz) {
            for (int idy = 0; idy < this.textureH + 1; ++idy) {
                for (int idx = 0; idx < this.textureW + 1; ++idx) {
                    float[] pos = this.switchValues(idx, idy, idz);
                    this.vertices.add(new NMTVertex(x + xS * pos[0], y + yS * pos[1], z + zS * pos[2]));
                }
            }
        }
    }

    protected void createSprite() {
        int texW = this.textureW + 1;
        int texH = this.textureH + 1;
        int texS = texW * texH;
        for (int idz = 0; idz < this.layers; ++idz) {
            int layerX = idz % this.layersPerRow;
            int layerY = (int)Math.floor((float)idz / (float)this.layersPerRow);
            for (int idy = 0; idy < this.textureH; ++idy) {
                for (int idx = 0; idx < this.textureW; ++idx) {
                    int[] verts = new int[]{idx + idy * texW + idz * texS, idx + 1 + idy * texW + idz * texS, idx + 1 + (idy + 1) * texW + idz * texS, idx + (idy + 1) * texW + idz * texS, idx + idy * texW + texS + idz * texS, idx + 1 + idy * texW + texS + idz * texS, idx + 1 + (idy + 1) * texW + texS + idz * texS, idx + (idy + 1) * texW + texS + idz * texS};
                    this.createVoxel(verts, idx + layerX * this.textureW, idy + layerY * this.textureH);
                }
            }
        }
    }

    protected float[] switchValues(float val1, float val2, float val3) {
        float val4;
        float[] val = new float[]{val1, val2, val3};
        if (this.rotations[0]) {
            val4 = val[2];
            val[2] = val[1];
            val[1] = val4;
        }
        if (this.rotations[1]) {
            val4 = val[2];
            val[2] = val[0];
            val[0] = val4;
        }
        if (this.rotations[2]) {
            val4 = val[1];
            val[1] = val[0];
            val[0] = val4;
        }
        return val;
    }
}

