/*
 * Decompiled with CFR 0.152.
 */
package com.overminddl1.mods.NMT;

import com.overminddl1.mods.NMT.NMTModelRenderer;
import com.overminddl1.mods.NMT.NMTPolygon;
import com.overminddl1.mods.NMT.NMTTextureVertex;
import com.overminddl1.mods.NMT.NMTVertex;
import java.util.ArrayList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;

public abstract class NMTModelBase {
    public String name;
    protected NMTModelRenderer renderer;
    public ArrayList<NMTPolygon> polygons;
    public ArrayList<NMTVertex> vertices;
    public boolean doCompile;
    public boolean doRender;

    public NMTModelBase(NMTModelRenderer nmtmodelrenderer) {
        this.renderer = nmtmodelrenderer;
        this.polygons = new ArrayList();
        this.vertices = new ArrayList();
        this.doCompile = true;
        this.doRender = false;
    }

    public abstract NMTModelBase create();

    public void compile(Tessellator tessellator, float scale) {
        this.render(tessellator, scale);
    }

    public void render(Tessellator tessellator, float scale) {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            this.polygons.get(idx).draw(tessellator, scale, this.renderer.disableTextureMapping);
        }
    }

    public NMTTextureVertex addVertex(float x, float y, float z, float u, float v) {
        NMTVertex vertex = new NMTVertex(x, y, z);
        this.vertices.add(vertex);
        return this.addVertex(vertex, u, v);
    }

    public NMTTextureVertex addVertex(NMTVertex vertex, float u, float v) {
        return new NMTTextureVertex(vertex, u, v);
    }

    public NMTTextureVertex addVertex(NMTVertex vertex, float u, float v, Vec3 n) {
        return new NMTTextureVertex(vertex, u, v, n);
    }

    public NMTTextureVertex addVertexFromOrig(NMTVertex vertex, float u, float v, Vec3 n) {
        Vec3 calcN = Vec3.func_72443_a((double)(vertex.transformVector.field_72450_a - n.field_72450_a), (double)(vertex.transformVector.field_72448_b - n.field_72448_b), (double)(vertex.transformVector.field_72449_c - n.field_72449_c));
        calcN = calcN.func_72432_b();
        return new NMTTextureVertex(vertex, u, v, calcN);
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex(this.vertices.get(vert1), u2, v1), this.addVertex(this.vertices.get(vert2), u1, v1), this.addVertex(this.vertices.get(vert3), u1, v2), this.addVertex(this.vertices.get(vert4), u2, v2)}));
    }

    public void addQuad(ArrayList<NMTVertex> verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex(verts.get(vert1), u2, v1), this.addVertex(verts.get(vert2), u1, v1), this.addVertex(verts.get(vert3), u1, v2), this.addVertex(verts.get(vert4), u2, v2)}));
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, Vec3 orig) {
        NMTPolygon poly = new NMTPolygon(new NMTTextureVertex[]{this.addVertexFromOrig(this.vertices.get(vert1), u2, v1, orig), this.addVertexFromOrig(this.vertices.get(vert2), u1, v1, orig), this.addVertexFromOrig(this.vertices.get(vert3), u1, v2, orig), this.addVertexFromOrig(this.vertices.get(vert4), u2, v2, orig)});
        poly.indivNormal = true;
        this.polygons.add(poly);
    }

    public void addQuad(ArrayList<NMTVertex> verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, Vec3 orig) {
        NMTPolygon poly = new NMTPolygon(new NMTTextureVertex[]{this.addVertexFromOrig(verts.get(vert1), u2, v1, orig), this.addVertexFromOrig(verts.get(vert2), u1, v1, orig), this.addVertexFromOrig(verts.get(vert3), u1, v2, orig), this.addVertexFromOrig(verts.get(vert4), u2, v2, orig)});
        poly.indivNormal = true;
        this.polygons.add(poly);
    }

    public void addQuad(int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, Vec3[] n) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex(this.vertices.get(vert1), u2, v1, n[0]), this.addVertex(this.vertices.get(vert2), u1, v1, n[1]), this.addVertex(this.vertices.get(vert3), u1, v2, n[2]), this.addVertex(this.vertices.get(vert4), u2, v2, n[3])}));
    }

    public void addQuad(ArrayList<NMTVertex> verts, int vert1, int vert2, int vert3, int vert4, float u1, float v1, float u2, float v2, Vec3[] n) {
        this.polygons.add(new NMTPolygon(new NMTTextureVertex[]{this.addVertex(verts.get(vert1), u2, v1, n[0]), this.addVertex(verts.get(vert2), u1, v1, n[1]), this.addVertex(verts.get(vert3), u1, v2, n[2]), this.addVertex(verts.get(vert4), u2, v2, n[3])}));
    }

    public NMTModelBase setName(String s) {
        this.name = s;
        return this;
    }

    public void invertNormals() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            this.polygons.get((int)idx).invertNormal = true;
        }
    }

    public void flipFaces() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            this.polygons.get(idx).flipFace();
        }
    }

    public void setIndivNormals() {
        for (int idx = 0; idx < this.polygons.size(); ++idx) {
            this.polygons.get((int)idx).indivNormal = true;
        }
    }

    public final ArrayList<NMTVertex> getVertexList() {
        return this.vertices;
    }

    public void doMirror(boolean x, boolean y, boolean z) {
        for (int idx = 0; idx < this.vertices.size(); ++idx) {
            NMTVertex vert = this.vertices.get(idx);
            vert.baseVector.field_72450_a = vert.baseVector.field_72450_a * (double)(x ? -1 : 1);
            vert.baseVector.field_72448_b = vert.baseVector.field_72448_b * (double)(y ? -1 : 1);
            vert.baseVector.field_72449_c = vert.baseVector.field_72449_c * (double)(z ? -1 : 1);
        }
        if (x ^ y ^ z) {
            this.flipFaces();
        }
    }

    protected void setNormalFromOrigin(NMTVertex vertex, Vec3 n) {
        Vec3 calcN = Vec3.func_72443_a((double)(vertex.transformVector.field_72450_a - n.field_72450_a), (double)(vertex.transformVector.field_72448_b - n.field_72448_b), (double)(vertex.transformVector.field_72449_c - n.field_72449_c));
        calcN = calcN.func_72432_b();
        vertex.setNormals(calcN);
    }
}

