/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static void checkMembers(String prefix, String[] ... specs) {
        try {
            for (String[] spec : specs) {
                Class<?> clazz = Class.forName(prefix + spec[0]);
                for (int i = 1; i < spec.length; ++i) {
                    if (clazz.getField(spec[i]) != null) continue;
                    throw new NoSuchFieldException(prefix + spec[0] + " : " + spec[i]);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object invokeGenericMethodOneArg(Object obj, String methodName, Object arg) {
        Class<?> objClass = obj.getClass();
        Class<?> argClass = arg.getClass();
        Method methodFound = null;
        boolean denyObject = false;
        for (Method method : objClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            if (parameterTypes[0] != Object.class && !parameterTypes[0].isAssignableFrom(argClass)) {
                denyObject = true;
            }
            if ((methodFound != null || !parameterTypes[0].isAssignableFrom(argClass)) && (methodFound == null || !methodFound.getParameterTypes()[0].isAssignableFrom(parameterTypes[0]))) continue;
            methodFound = method;
        }
        if (denyObject && methodFound.getParameterTypes()[0] == Object.class) {
            return null;
        }
        if (methodFound != null && methodFound.getParameterTypes()[0].isAssignableFrom(argClass)) {
            try {
                Object res = methodFound.invoke(obj, arg);
                return res;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static Object invokeMethodNoArgs(Object obj, String methodName, Class<?> ... returnTypePreference) {
        Class<?> objClass = obj.getClass();
        Method methodFound = null;
        int returnTypeIndex = returnTypePreference.length;
        for (Method method : objClass.getMethods()) {
            int i;
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 0) continue;
            Class<?> returnType = method.getReturnType();
            if (methodFound == null) {
                methodFound = method;
                for (i = 0; i < returnTypeIndex; ++i) {
                    if (returnTypePreference[i] != returnType) continue;
                    returnTypeIndex = i;
                    break;
                }
            } else {
                for (i = 0; i < returnTypeIndex; ++i) {
                    if (returnTypePreference[i] != returnType) continue;
                    methodFound = method;
                    returnTypeIndex = i;
                    break;
                }
            }
            if (returnTypeIndex == 0) break;
        }
        if (methodFound != null) {
            try {
                Object res = methodFound.invoke(obj, new Object[0]);
                return res;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }
}

