/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.RayTracing;
import org.bukkit.Location;

public class InteractRayTracing
extends RayTracing {
    private static final int[][] incr = new int[][]{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {-1, 0, 0}, {0, -1, 0}, {0, 0, -1}};
    protected BlockCache blockCache = null;
    protected boolean collides = false;
    protected boolean strict = false;
    protected int lastBx;
    protected int lastBy;
    protected int lastBz;
    protected int targetBx;
    protected int targetBy;
    protected int targetBz;

    public InteractRayTracing() {
    }

    public InteractRayTracing(boolean strict) {
        this.strict = strict;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        super.set(x0, y0, z0, x1, y1, z1);
        this.collides = false;
        this.lastBx = this.blockX;
        this.lastBy = this.blockY;
        this.lastBz = this.blockZ;
        this.targetBx = Location.locToBlock((double)x1);
        this.targetBy = Location.locToBlock((double)y1);
        this.targetBz = Location.locToBlock((double)z1);
    }

    public boolean collides() {
        return this.collides;
    }

    public void cleanup() {
        if (this.blockCache != null) {
            this.blockCache = null;
        }
    }

    private final boolean doesCollide(int blockX, int blockY, int blockZ) {
        int id = this.blockCache.getTypeId(blockX, blockY, blockZ);
        long flags = BlockProperties.getBlockFlags(id);
        if ((flags & 4L) == 0L) {
            return false;
        }
        if ((flags & 0x40BL) != 0L) {
            return false;
        }
        return this.blockCache.isFullBounds(blockX, blockY, blockZ);
    }

    private final boolean allowsWorkaround(int blockX, int blockY, int blockZ) {
        int dX = blockX - this.lastBx;
        int dY = blockY - this.lastBy;
        int dZ = blockZ - this.lastBz;
        double dSq = dX * dX + dY * dY + dZ * dZ;
        for (int i = 0; i < 6; ++i) {
            int dRz;
            int dRy;
            int dRx;
            int rZ;
            int rY;
            int[] dir = incr[i];
            int rX = blockX + dir[0];
            if (Math.abs(this.lastBx - rX) > 1 || Math.abs(this.lastBy - (rY = blockY + dir[1])) > 1 || Math.abs(this.lastBz - (rZ = blockZ + dir[2])) > 1 || (double)((dRx = rX - this.lastBx) * dRx + (dRy = rY - this.lastBy) * dRy + (dRz = rZ - this.lastBz) * dRz) <= dSq || this.doesCollide(rX, rY, rZ)) continue;
            return true;
        }
        return false;
    }

    protected boolean step(int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dT) {
        if (blockX == this.targetBx && blockZ == this.targetBz && blockY == this.targetBy || !this.doesCollide(blockX, blockY, blockZ)) {
            this.lastBx = blockX;
            this.lastBy = blockY;
            this.lastBz = blockZ;
            return true;
        }
        if (this.strict || blockX == this.lastBx && blockZ == this.lastBz && blockY == this.lastBy) {
            this.collides = true;
            return false;
        }
        if (this.allowsWorkaround(blockX, blockY, blockZ)) {
            this.lastBx = blockX;
            this.lastBy = blockY;
            this.lastBz = blockZ;
            return true;
        }
        this.collides = true;
        return false;
    }
}

