/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtil {
    public static String toString(Throwable t) {
        StringWriter w = new StringWriter();
        t.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public static void logInfo(String msg) {
        LogUtil.log(Level.INFO, msg);
    }

    public static void logWarning(String msg) {
        LogUtil.log(Level.WARNING, msg);
    }

    public static void logSevere(String msg) {
        LogUtil.log(Level.SEVERE, msg);
    }

    public static void logInfo(Throwable t) {
        LogUtil.log(Level.INFO, LogUtil.toString(t));
    }

    public static void logWarning(Throwable t) {
        LogUtil.log(Level.WARNING, LogUtil.toString(t));
    }

    public static void logSevere(Throwable t) {
        LogUtil.log(Level.SEVERE, LogUtil.toString(t));
    }

    public static void log(Level level, String msg) {
        Bukkit.getLogger().log(level, msg);
    }

    public static boolean scheduleLogInfo(String message) {
        return LogUtil.scheduleLog(Level.INFO, message);
    }

    public static boolean scheduleLogWarning(String message) {
        return LogUtil.scheduleLog(Level.WARNING, message);
    }

    public static boolean scheduleLogSevere(String message) {
        return LogUtil.scheduleLog(Level.SEVERE, message);
    }

    public static boolean scheduleLogInfo(Throwable t) {
        return LogUtil.scheduleLog(Level.INFO, LogUtil.toString(t));
    }

    public static boolean scheduleLogWarning(Throwable t) {
        return LogUtil.scheduleLog(Level.WARNING, LogUtil.toString(t));
    }

    public static boolean scheduleLogSevere(Throwable t) {
        return LogUtil.scheduleLog(Level.SEVERE, LogUtil.toString(t));
    }

    public static boolean scheduleLog(final Level level, final String message) {
        try {
            return Bukkit.getScheduler().scheduleSyncDelayedTask(Bukkit.getPluginManager().getPlugin("NoCheatPlus"), new Runnable(){

                public final void run() {
                    Bukkit.getLogger().log(level, message);
                }
            }) != -1;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static <O> boolean scheduleLogInfo(List<O> parts, String link) {
        return LogUtil.scheduleLog(Level.INFO, parts, link);
    }

    public static <O> boolean scheduleLog(Level level, List<O> parts, String link) {
        return LogUtil.scheduleLog(level, StringUtil.join(parts, link));
    }
}

