/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.utilities.BlockCache;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BlockCacheBukkit
extends BlockCache {
    protected World world;

    public BlockCacheBukkit(World world) {
        this.setAccess(world);
    }

    public void setAccess(World world) {
        this.world = world;
    }

    public int fetchTypeId(int x, int y, int z) {
        return this.world.getBlockTypeIdAt(x, y, z);
    }

    public int fetchData(int x, int y, int z) {
        return this.world.getBlockAt(x, y, z).getData();
    }

    public double[] fetchBounds(int x, int y, int z) {
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            for (Entity other : entity.getNearbyEntities(2.0, 2.0, 2.0)) {
                EntityType type = other.getType();
                if (type != EntityType.BOAT) continue;
                Location loc = entity.getLocation();
                return Math.abs(loc.getY() - minY) < 0.7;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return false;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
    }
}

