/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandUtil {
    public static CommandMap getCommandMap() {
        try {
            return NCPAPIProvider.getNoCheatPlusAPI().getMCAccess().getCommandMap();
        }
        catch (Throwable t) {
            LogUtil.logSevere(t);
            return null;
        }
    }

    public static Collection<Command> getCommands() {
        CommandMap commandMap = CommandUtil.getCommandMap();
        if (commandMap != null && commandMap instanceof SimpleCommandMap) {
            return ((SimpleCommandMap)commandMap).getCommands();
        }
        LinkedHashSet<Command> commands = new LinkedHashSet<Command>(100);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            JavaPlugin javaPlugin;
            Map map;
            if (!(plugin instanceof JavaPlugin) || (map = (javaPlugin = (JavaPlugin)plugin).getDescription().getCommands()) == null) continue;
            for (String label : map.keySet()) {
                PluginCommand command = javaPlugin.getCommand(label);
                if (command == null) continue;
                commands.add((Command)command);
            }
        }
        return commands;
    }

    public static String getCommandLabel(String alias, boolean strict) {
        Command command = CommandUtil.getCommand(alias);
        if (command == null) {
            return strict ? null : alias.trim().toLowerCase();
        }
        return command.getLabel().trim().toLowerCase();
    }

    public static Command getCommand(String alias) {
        String lcAlias = alias.trim().toLowerCase();
        CommandMap map = CommandUtil.getCommandMap();
        if (map != null) {
            return map.getCommand(lcAlias);
        }
        return null;
    }

    public static List<String> getCheckTypeTabMatches(String input) {
        String name;
        String ref = input.toUpperCase().replace('-', '_').replace('.', '_');
        ArrayList<String> res = new ArrayList<String>();
        for (CheckType checkType : CheckType.values()) {
            name = checkType.name();
            if (!name.startsWith(ref)) continue;
            res.add(name);
        }
        if (ref.indexOf(95) == -1) {
            for (CheckType checkType : CheckType.values()) {
                name = checkType.name();
                String[] split = name.split("_", 2);
                if (split.length <= 1 || !split[1].startsWith(ref)) continue;
                res.add(name);
            }
        }
        if (!res.isEmpty()) {
            Collections.sort(res);
            return res;
        }
        return null;
    }
}

