/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MediumLiftOff;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.Velocity;
import fr.neatmonster.nocheatplus.utilities.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurvivalFly
extends Check {
    public static final double sneakingSpeed = 0.13;
    public static final double walkingSpeed = 0.22;
    public static final double sprintingSpeed = 0.35;
    public static final double blockingSpeed = 0.16;
    public static final double swimmingSpeed = 0.115;
    public static final double webSpeed = 0.105;
    public static final double climbSpeed = 0.35;
    public static final double modIce = 2.5;
    public static final double modDownStream = 1.6521739130434783;
    private static final int bunnyHopMax = 9;
    private final ArrayList<String> tags = new ArrayList(15);
    private final Set<String> reallySneaking = new HashSet<String>(30);

    public SurvivalFly() {
        super(CheckType.MOVING_SURVIVALFLY);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, long now) {
        boolean resetTo;
        boolean resetFrom;
        boolean sprinting;
        this.tags.clear();
        boolean bl = sprinting = now <= data.timeSprinting + cc.sprintingGrace;
        if (sprinting && now != data.timeSprinting) {
            this.tags.add("sprintgrace");
        }
        boolean fromOnGround = from.isOnGround();
        boolean toOnGround = to.isOnGround();
        double xDistance = to.getX() - from.getX();
        double yDistance = to.getY() - from.getY();
        double zDistance = to.getZ() - from.getZ();
        double hDistance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        if (!data.hasSetBack()) {
            data.setSetBack(from);
        }
        if (fromOnGround || from.isResetCond()) {
            resetFrom = true;
        } else {
            boolean lostGround = false;
            if (yDistance >= -0.5 && yDistance <= 0.52 + data.jumpAmplifier * 0.2) {
                if (from.isAboveStairs()) {
                    this.applyLostGround(player, from, true, data, "stairs");
                    lostGround = true;
                }
                if (!lostGround && yDistance <= 0.0 && this.lostGroundDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                    lostGround = true;
                }
                if (!lostGround && yDistance >= 0.0 && this.lostGroundAscend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                    lostGround = true;
                }
            } else if (yDistance < -0.5 && hDistance <= 0.5 && this.lostGroundFastDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                lostGround = true;
            }
            resetFrom = lostGround;
        }
        boolean downStream = hDistance > 0.115 && from.isInLiquid() && from.isDownStream(xDistance, zDistance);
        double hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, data, cc, false);
        double hDistanceAboveLimit = hDistance - hAllowedDistance;
        double hFreedom = 0.0;
        if (hDistanceAboveLimit > 0.0) {
            double extraUsed;
            if (data.sfHBufExtra > 0) {
                extraUsed = 0.11;
                hDistanceAboveLimit = Math.max(0.0, hDistanceAboveLimit - extraUsed);
                --data.sfHBufExtra;
                this.tags.add("hbufextra");
                if (data.sfHBufExtra < 3 && to.isOnGround() || to.isResetCond()) {
                    data.sfHBufExtra = 0;
                }
            } else {
                extraUsed = 0.0;
            }
            if (hDistanceAboveLimit > 0.0) {
                hFreedom = data.getHorizontalFreedom();
                if (hFreedom < hDistanceAboveLimit) {
                    hFreedom += data.useHorizontalVelocity(hDistanceAboveLimit - hFreedom);
                }
                if (hFreedom > 0.0) {
                    hDistanceAboveLimit = Math.max(0.0, hDistanceAboveLimit - hFreedom);
                }
            } else {
                data.hVelActive.clear();
                hFreedom = 0.0;
            }
            if (hDistanceAboveLimit > 0.0) {
                hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, data, cc, true);
                hDistanceAboveLimit = hFreedom > 0.0 ? hDistance - hAllowedDistance - extraUsed - hFreedom : hDistance - hAllowedDistance - extraUsed;
                if (hAllowedDistance > 0.0) {
                    this.tags.add("hspeed");
                }
            }
        } else {
            data.hVelActive.clear();
            data.sfHBufExtra = 0;
        }
        if (hDistanceAboveLimit <= 0.0 && hDistance > 0.1 && yDistance == 0.0 && BlockProperties.isLiquid(to.getTypeId()) && !toOnGround && to.getY() % 1.0 < 0.8) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
            this.tags.add("waterwalk");
        }
        if (hDistanceAboveLimit <= 0.0 && sprinting && data.hVelActive.isEmpty()) {
            float yaw = from.getYaw();
            if ((xDistance < 0.0 && zDistance > 0.0 && yaw > 180.0f && yaw < 270.0f || xDistance < 0.0 && zDistance < 0.0 && yaw > 270.0f && yaw < 360.0f || xDistance > 0.0 && zDistance < 0.0 && yaw > 0.0f && yaw < 90.0f || xDistance > 0.0 && zDistance > 0.0 && yaw > 90.0f && yaw < 180.0f) && !player.hasPermission("nocheatplus.checks.moving.survivalfly.sprinting")) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
                this.tags.add("sprintback");
            }
        }
        --data.bunnyhopDelay;
        if (hDistanceAboveLimit > 0.0 && sprinting && data.bunnyhopDelay <= 0 && hDistanceAboveLimit > 0.05 && hDistanceAboveLimit < 0.28) {
            data.bunnyhopDelay = 9;
            hDistanceAboveLimit = 0.0;
            this.tags.add("bunny");
        }
        boolean bl2 = resetTo = toOnGround || to.isResetCond();
        if (hDistanceAboveLimit > 0.0 && data.sfHorizontalBuffer != 0.0) {
            if (data.sfHorizontalBuffer > 0.0) {
                this.tags.add("hbufuse");
            } else {
                this.tags.add("hbufpen");
            }
            hDistanceAboveLimit -= data.sfHorizontalBuffer;
            data.sfHorizontalBuffer = 0.0;
            if (hDistanceAboveLimit < 0.0) {
                data.sfHorizontalBuffer = -hDistanceAboveLimit;
            }
        } else if (hDistance != 0.0) {
            data.sfHorizontalBuffer = Math.min(1.0, data.sfHorizontalBuffer - hDistanceAboveLimit);
        }
        if (data.sfDirty) {
            if (resetFrom || resetTo) {
                data.sfDirty = false;
            } else {
                this.tags.add("dirty");
            }
        }
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        if (from.isInWeb()) {
            Location silentSetBack;
            data.sfNoLowJump = true;
            vAllowedDistance = from.isOnGround() ? 0.1 : 0.0;
            data.jumpAmplifier = 0.0;
            vDistanceAboveLimit = yDistance - vAllowedDistance;
            if (cc.survivalFlyCobwebHack && vDistanceAboveLimit > 0.0 && hDistanceAboveLimit <= 0.0 && (silentSetBack = this.hackCobweb(player, data, to, now, vDistanceAboveLimit)) != null) {
                if (cc.debug) {
                    this.tags.add("silentsbcobweb");
                    this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
                }
                return silentSetBack;
            }
            if (vDistanceAboveLimit > 0.0) {
                this.tags.add("vweb");
            }
        } else if (data.verticalFreedom <= 0.001 && from.isOnClimbable()) {
            data.sfNoLowJump = true;
            double jumpHeight = 1.35 + (data.jumpAmplifier > 0.0 ? 0.6 + data.jumpAmplifier - 1.0 : 0.0);
            if (yDistance > 0.35 && !from.isOnGround(jumpHeight, 0.0, 0.0, 512L)) {
                this.tags.add("climbspeed");
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance - 0.35);
            }
            if (!(!(yDistance > 0.0) || fromOnGround || toOnGround || data.noFallAssumeGround || from.canClimbUp(jumpHeight))) {
                this.tags.add("climbup");
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance);
            }
        } else if (data.verticalFreedom <= 0.001 && from.isInLiquid() && (Math.abs(yDistance) > 0.2 || to.isInLiquid())) {
            data.sfNoLowJump = true;
            if (yDistance >= 0.0 && (vDistanceAboveLimit = yDistance - (vAllowedDistance = 0.135)) > 0.0) {
                if (yDistance <= 0.5 && (data.mediumLiftOff == MediumLiftOff.GROUND && !BlockProperties.isLiquid(from.getTypeIdAbove()) || !to.isInLiquid() || toOnGround || data.sfLastYDist - yDistance >= 0.01 || to.isAboveStairs())) {
                    vAllowedDistance = 0.615;
                    vDistanceAboveLimit = yDistance - vAllowedDistance;
                }
                if (vDistanceAboveLimit > 0.0) {
                    this.tags.add("swimup");
                }
            }
        } else {
            int maxJumpPhase;
            vAllowedDistance = 1.35 + data.verticalFreedom;
            if (data.mediumLiftOff == MediumLiftOff.LIMIT_JUMP) {
                maxJumpPhase = 3;
                data.sfNoLowJump = true;
                if (data.sfJumpPhase > 0) {
                    this.tags.add("limitjump");
                }
            } else if (data.jumpAmplifier > 0.0) {
                vAllowedDistance += 0.6 + data.jumpAmplifier - 1.0;
                maxJumpPhase = (int)(9.0 + (data.jumpAmplifier - 1.0) * 6.0);
            } else {
                maxJumpPhase = 6;
            }
            if (data.sfJumpPhase > maxJumpPhase && data.verticalVelocityCounter <= 0) {
                if (data.sfDirty || yDistance < 0.0 || resetFrom) {
                    if (data.getSetBackY() > to.getY()) {
                        if (data.sfJumpPhase <= 2 * maxJumpPhase) {
                            vAllowedDistance -= Math.max(0.0, (double)(data.sfJumpPhase - maxJumpPhase) * 0.15);
                        }
                    } else {
                        vAllowedDistance -= Math.max(0.0, (double)(data.sfJumpPhase - maxJumpPhase) * 0.15);
                    }
                } else if (!data.sfDirty) {
                    this.tags.add("maxphase");
                    vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.max(yDistance, 0.15));
                }
            }
            if ((vDistanceAboveLimit = Math.max(vDistanceAboveLimit, to.getY() - data.getSetBackY() - vAllowedDistance)) > 0.0) {
                this.tags.add("vdist");
            }
            if ((fromOnGround || data.noFallAssumeGround) && toOnGround && Math.abs(yDistance - 1.0) <= cc.yStep && vDistanceAboveLimit <= 0.0 && yDistance > 0.52 + data.jumpAmplifier * 0.2 && !player.hasPermission("nocheatplus.checks.moving.survivalfly.step")) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                this.tags.add("step");
            }
        }
        if (data.noFallAssumeGround || fromOnGround || toOnGround) {
            data.jumpAmplifier = this.getJumpAmplifier(player);
        }
        if (!resetFrom && !resetTo) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, this.verticalAccounting(now, from, to, hDistance, yDistance, data, cc));
        }
        double result = (Math.max(hDistanceAboveLimit, 0.0) + Math.max(vDistanceAboveLimit, 0.0)) * 100.0;
        if (cc.debug) {
            this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
        }
        ++data.sfJumpPhase;
        if (result > 0.0) {
            Location vLoc = this.handleViolation(now, result, player, from, to, data, cc);
            if (vLoc != null) {
                return vLoc;
            }
        } else if (now - data.sfVLTime > cc.survivalFlyVLFreeze) {
            data.survivalFlyVL *= 0.95;
        }
        if (to.isInLiquid()) {
            data.mediumLiftOff = fromOnGround && !toOnGround && data.mediumLiftOff == MediumLiftOff.GROUND && data.sfJumpPhase <= 1 && !from.isInLiquid() ? MediumLiftOff.GROUND : (to.isNextToGround(0.15, 0.4) ? MediumLiftOff.GROUND : MediumLiftOff.LIMIT_JUMP);
        } else if (to.isInWeb()) {
            data.mediumLiftOff = MediumLiftOff.LIMIT_JUMP;
        } else if (resetTo) {
            data.mediumLiftOff = MediumLiftOff.GROUND;
        } else if (from.isInLiquid()) {
            data.mediumLiftOff = !resetTo && data.mediumLiftOff == MediumLiftOff.GROUND && data.sfJumpPhase <= 1 ? MediumLiftOff.GROUND : (to.isNextToGround(0.15, 0.4) ? MediumLiftOff.GROUND : MediumLiftOff.LIMIT_JUMP);
        } else if (from.isInWeb()) {
            data.mediumLiftOff = MediumLiftOff.LIMIT_JUMP;
        } else if (resetFrom || data.noFallAssumeGround) {
            data.mediumLiftOff = MediumLiftOff.GROUND;
        }
        data.toWasReset = resetTo || data.noFallAssumeGround;
        boolean bl3 = data.fromWasReset = resetFrom || data.noFallAssumeGround;
        if (data.verticalVelocityUsed > cc.velocityGraceTicks && yDistance <= 0.0 && data.sfLastYDist > 0.0) {
            data.verticalVelocityCounter = 0;
            data.verticalVelocity = 0.0;
        }
        if (resetTo) {
            data.setSetBack(to);
            data.sfJumpPhase = 0;
            data.clearAccounting();
            data.sfLowJump = false;
            data.sfNoLowJump = false;
            if (data.verticalVelocityUsed > cc.velocityGraceTicks && toOnGround && yDistance < 0.0) {
                data.verticalVelocityCounter = 0;
                data.verticalFreedom = 0.0;
                data.verticalVelocity = 0.0;
                data.verticalVelocityUsed = 0;
            }
        } else if (resetFrom) {
            data.setSetBack(from);
            data.sfJumpPhase = 1;
            data.clearAccounting();
            data.sfLowJump = false;
        }
        double d = cc.velocityStrictInvalidation ? hAllowedDistance : hAllowedDistance / 2.0;
        if (hDistance <= d) {
            data.hVelActive.clear();
        }
        data.sfLastYDist = yDistance;
        return null;
    }

    private void outputDebug(Player player, PlayerLocation to, MovingData data, MovingConfig cc, double hDistance, double hAllowedDistance, double hFreedom, double yDistance, double vAllowedDistance, boolean fromOnGround, boolean resetFrom, boolean toOnGround, boolean resetTo) {
        StringBuilder builder = new StringBuilder(500);
        String hBuf = data.sfHorizontalBuffer < 1.0 ? " hbuf=" + StringUtil.fdec3.format(data.sfHorizontalBuffer) : "";
        String hBufExtra = data.sfHBufExtra > 0 ? " hbufextra=" + data.sfHBufExtra : "";
        String hVelUsed = hFreedom > 0.0 ? " hVelUsed=" + StringUtil.fdec3.format(hFreedom) : "";
        builder.append(player.getName() + " SurvivalFly\nground: " + (data.noFallAssumeGround ? "(assumeonground) " : "") + (fromOnGround ? "onground -> " : (resetFrom ? "resetcond -> " : "--- -> ")) + (toOnGround ? "onground" : (resetTo ? "resetcond" : "---")) + ", jumpphase: " + data.sfJumpPhase);
        builder.append("\n hDist: " + StringUtil.fdec3.format(hDistance) + " / " + StringUtil.fdec3.format(hAllowedDistance) + hBuf + hBufExtra + hVelUsed + " , vDist: " + StringUtil.fdec3.format(yDistance) + " (" + StringUtil.fdec3.format(to.getY() - data.getSetBackY()) + " / " + StringUtil.fdec3.format(vAllowedDistance) + "), sby=" + (data.hasSetBack() ? Double.valueOf(data.getSetBackY()) : "?"));
        if (data.verticalVelocityCounter > 0 || data.verticalFreedom >= 0.001) {
            builder.append("\n vertical freedom: " + StringUtil.fdec3.format(data.verticalFreedom) + " (vel=" + StringUtil.fdec3.format(data.verticalVelocity) + "/counter=" + data.verticalVelocityCounter + "/used=" + data.verticalVelocityUsed);
        }
        if (!data.hVelActive.isEmpty()) {
            builder.append("\n horizontal velocity (active):");
            this.addVeloctiy(builder, data.hVelActive);
        }
        if (!data.hVelQueued.isEmpty()) {
            builder.append("\n horizontal velocity (queued):");
            this.addVeloctiy(builder, data.hVelQueued);
        }
        if (!resetFrom && !resetTo && cc.survivalFlyAccountingV && data.vDistAcc.count() > data.vDistAcc.bucketCapacity()) {
            builder.append("\n vacc=" + data.vDistAcc.toInformalString());
        }
        if (player.isSleeping()) {
            this.tags.add("sleeping");
        }
        if (player.getFoodLevel() <= 5 && player.isSprinting()) {
            this.tags.add("lowfoodsprint");
        }
        if (!this.tags.isEmpty()) {
            builder.append("\n tags: " + StringUtil.join(this.tags, "+"));
        }
        builder.append("\n");
        System.out.print(builder.toString());
    }

    private void addVeloctiy(StringBuilder builder, List<Velocity> entries) {
        for (Velocity vel : entries) {
            builder.append(" ");
            builder.append(vel);
        }
    }

    private boolean lostGroundAscend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double dZ;
        double dY;
        double dX;
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance <= 0.5 && hDistance < 0.5 && setBackYDistance <= 1.3 + 0.2 * data.jumpAmplifier && to.isOnGround() && (data.sfLastYDist < 0.0 || from.isOnGround(0.5 - Math.abs(yDistance)))) {
            return this.applyLostGround(player, from, true, data, "step");
        }
        if (data.fromX != Double.MAX_VALUE && yDistance > 0.0 && data.sfLastYDist < 0.0 && !to.isOnGround() && (setBackYDistance > 0.0 && setBackYDistance <= 1.5 + 0.2 * data.jumpAmplifier || setBackYDistance < 0.0 && Math.abs(setBackYDistance) < 3.0) && (dX = from.getX() - data.fromX) * dX + (dY = from.getY() - data.fromY) * dY + (dZ = from.getZ() - data.fromZ) * dZ < 0.5) {
            double minY;
            double iY = minY = Math.min(data.toY, Math.min(data.fromY, from.getY()));
            double r = from.getWidth() / 2.0;
            double yMargin = cc.yOnGround;
            if (BlockProperties.isOnGround(from.getBlockCache(), Math.min(data.fromX, from.getX()) - r, iY - yMargin, Math.min(data.fromZ, from.getZ()) - r, Math.max(data.fromX, from.getX()) + r, iY + 0.25, Math.max(data.fromZ, from.getZ()) + r, 0L)) {
                return this.applyLostGround(player, from, true, data, "interpolate");
            }
        }
        return false;
    }

    private boolean lostGroundDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (data.sfJumpPhase <= 7) {
            if (data.sfLastYDist <= yDistance && setBackYDistance < 0.0 && !to.isOnGround() && from.isOnGround(0.6, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "pyramid");
            }
            if (yDistance == 0.0 && data.sfLastYDist > 0.0 && data.sfLastYDist < 0.25 && (double)data.sfJumpPhase <= 6.0 + data.jumpAmplifier * 3.0 && setBackYDistance > 1.0 && setBackYDistance < 1.5 + 0.2 * data.jumpAmplifier && !to.isOnGround() && from.isOnGround(0.25, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "ministep");
            }
        }
        if (yDistance < 0.0 && hDistance <= 0.5 && data.sfLastYDist < 0.0 && yDistance > data.sfLastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.2, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "edge");
        }
        return false;
    }

    private boolean lostGroundFastDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        if (yDistance > data.sfLastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.3, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "fastedge");
        }
        return false;
    }

    private boolean applyLostGround(Player player, PlayerLocation from, boolean setBackSafe, MovingData data, String tag) {
        if (setBackSafe) {
            data.setSetBack(from);
        }
        data.sfJumpPhase = 0;
        data.jumpAmplifier = this.getJumpAmplifier(player);
        data.clearAccounting();
        data.noFallAssumeGround = true;
        this.tags.add("lostground_" + tag);
        return true;
    }

    private double getAllowedhDist(Player player, PlayerLocation from, PlayerLocation to, boolean sprinting, boolean downStream, double hDistance, MovingData data, MovingConfig cc, boolean checkPermissions) {
        if (checkPermissions) {
            this.tags.add("permchecks");
        }
        double hAllowedDistance = 0.0;
        if (from.isOnIce() || to.isOnIce()) {
            data.sfFlyOnIce = 20;
        } else if (data.sfFlyOnIce > 0) {
            --data.sfFlyOnIce;
        }
        boolean sfDirty = data.sfDirty;
        if (from.isInWeb()) {
            data.sfFlyOnIce = 0;
            hAllowedDistance = 0.105 * (double)cc.survivalFlyWalkingSpeed / 100.0;
        } else if (from.isInLiquid() && to.isInLiquid()) {
            hAllowedDistance = 0.115 * (double)cc.survivalFlySwimmingSpeed / 100.0;
        } else if (!(sfDirty || !player.isSneaking() || !this.reallySneaking.contains(player.getName()) || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.sneaking"))) {
            hAllowedDistance = 0.13 * (double)cc.survivalFlySneakingSpeed / 100.0;
        } else if (!(sfDirty || !player.isBlocking() || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking"))) {
            hAllowedDistance = 0.16 * (double)cc.survivalFlyBlockingSpeed / 100.0;
        } else {
            hAllowedDistance = !sprinting ? 0.22 * (double)cc.survivalFlyWalkingSpeed / 100.0 : 0.35 * (double)cc.survivalFlySprintingSpeed / 100.0;
            if (checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.speeding")) {
                hAllowedDistance *= (double)cc.survivalFlySpeedingSpeed / 100.0;
            }
        }
        if (data.sfFlyOnIce > 0) {
            hAllowedDistance *= 2.5;
        }
        if (downStream) {
            hAllowedDistance *= 1.6521739130434783;
        }
        if (hDistance <= hAllowedDistance) {
            return hAllowedDistance;
        }
        double speedAmplifier = this.mcAccess.getFasterMovementAmplifier(player);
        if (speedAmplifier != Double.NEGATIVE_INFINITY) {
            hAllowedDistance *= 1.0 + 0.2 * (speedAmplifier + 1.0);
        }
        return hAllowedDistance;
    }

    private final Location handleViolation(long now, double result, Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        data.survivalFlyVL += result;
        data.sfVLTime = now;
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, result, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", to.getLocation().distance(from.getLocation())));
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        if (this.executeActions(vd)) {
            return data.getSetBack(to);
        }
        data.clearAccounting();
        data.sfJumpPhase = 0;
        return null;
    }

    protected final void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        data.survivalFlyVL += cc.sfHoverViolation;
        data.sfVLTime = System.currentTimeMillis();
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, cc.sfHoverViolation, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", loc.getX(), loc.getY(), loc.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, "(HOVER)");
            vd.setParameter(ParameterName.DISTANCE, "0.0(HOVER)");
            vd.setParameter(ParameterName.TAGS, "hover");
        }
        if (this.executeActions(vd)) {
            if (data.hasSetBack()) {
                data.clearAccounting();
                data.sfJumpPhase = 0;
                data.sfLastYDist = Double.MAX_VALUE;
                data.toWasReset = false;
                data.fromWasReset = false;
                data.setTeleported(data.getSetBack(loc));
                player.teleport(data.getTeleported());
            } else {
                player.kickPlayer("Hovering?");
            }
        }
    }

    private double verticalAccounting(long now, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, MovingData data, MovingConfig cc) {
        boolean yDirChange;
        double vDistanceAboveLimit = 0.0;
        boolean bl = yDirChange = data.sfLastYDist != Double.MAX_VALUE && data.sfLastYDist != yDistance && (yDistance <= 0.0 && data.sfLastYDist >= 0.0 || yDistance >= 0.0 && data.sfLastYDist <= 0.0);
        if (yDirChange) {
            if (yDistance > 0.0) {
                if (data.toWasReset) {
                    this.tags.add("ychinc");
                } else if (data.verticalFreedom <= 0.001 && data.bunnyhopDelay < 9 && (!data.fromWasReset || data.sfLastYDist != 0.0)) {
                    vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                    this.tags.add("ychincfly");
                } else {
                    this.tags.add("ychincair");
                }
            } else {
                double setBackYDistance;
                this.tags.add("ychdec");
                if (!data.sfNoLowJump && !data.sfDirty && data.mediumLiftOff == MediumLiftOff.GROUND && (setBackYDistance = to.getY() - data.getSetBackY()) > 0.0) {
                    Player player = from.getPlayer();
                    double estimate = 1.15;
                    if (data.jumpAmplifier > 0.0) {
                        estimate += 0.5 * this.getJumpAmplifier(player);
                    }
                    if (setBackYDistance < estimate) {
                        int refY;
                        long flags = 132L;
                        if ((BlockProperties.getBlockFlags(from.getTypeIdAbove()) & 0x84L) == 0L && ((refY = Location.locToBlock((double)(from.getY() + 0.5))) == from.getBlockY() || (BlockProperties.getBlockFlags(from.getTypeId(from.getBlockX(), refY, from.getBlockZ())) & 0x84L) == 0L)) {
                            this.tags.add("lowjump");
                            data.sfLowJump = true;
                        }
                    }
                }
            }
        }
        if (cc.survivalFlyAccountingV) {
            if (yDirChange && data.sfLastYDist > 0.0) {
                data.vDistAcc.clear();
                data.vDistAcc.add((float)yDistance);
            } else if (data.verticalFreedom <= 0.001) {
                double accAboveLimit;
                if (yDistance != 0.0 && (accAboveLimit = SurvivalFly.verticalAccounting(now, from, to, yDistance, data.vDistAcc, this.tags, "vacc")) > vDistanceAboveLimit) {
                    vDistanceAboveLimit = accAboveLimit;
                }
            } else {
                data.vDistAcc.clear();
            }
        }
        return vDistanceAboveLimit;
    }

    private static final double verticalAccounting(long now, PlayerLocation from, PlayerLocation to, double yDistance, ActionAccumulator acc, ArrayList<String> tags, String tag) {
        acc.add((float)yDistance);
        int i1 = 1;
        int i2 = 2;
        if (acc.bucketCount(i1) > 0 && acc.bucketCount(i2) > 0) {
            float sc1 = acc.bucketScore(i1);
            float sc2 = acc.bucketScore(i2);
            double diff = sc1 - sc2;
            double aDiff = Math.abs(diff);
            if (diff > 0.0 || yDistance > -1.1 && aDiff <= 0.07) {
                if (yDistance < -1.1 && (aDiff < Math.abs(yDistance) || sc2 < -10.0f)) {
                    tags.add(tag + "grace");
                    return 0.0;
                }
                tags.add(tag);
                if (diff < 0.0) {
                    return 1.3 - aDiff;
                }
                return diff;
            }
        }
        return 0.0;
    }

    private final Location hackCobweb(Player player, MovingData data, PlayerLocation to, long now, double vDistanceAboveLimit) {
        if (now - data.sfCobwebTime > 3000L) {
            data.sfCobwebTime = now;
            data.sfCobwebVL = vDistanceAboveLimit * 100.0;
        } else {
            data.sfCobwebVL += vDistanceAboveLimit * 100.0;
        }
        if (data.sfCobwebVL < 550.0) {
            if (!data.hasSetBack()) {
                data.setSetBack(player.getLocation());
            }
            data.sfJumpPhase = 0;
            data.sfLastYDist = Double.MAX_VALUE;
            return data.getSetBack(to);
        }
        return null;
    }

    public void setReallySneaking(Player player, boolean sneaking) {
        if (sneaking) {
            this.reallySneaking.add(player.getName());
        } else {
            this.reallySneaking.remove(player.getName());
        }
    }

    protected final double getJumpAmplifier(Player player) {
        double amplifier = this.mcAccess.getJumpAmplifier(player);
        if (amplifier == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 + amplifier;
    }
}

