/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantEat
extends Check {
    public InstantEat() {
        super(CheckType.INVENTORY_INSTANTEAT);
    }

    public boolean check(Player player, int level) {
        long time = System.currentTimeMillis();
        InventoryData data = InventoryData.getData(player);
        boolean cancel = false;
        if (data.instantEatFood == null || level <= player.getFoodLevel()) {
            return false;
        }
        long expectedTimeWhenEatingFinished = Math.max(data.instantEatInteract, data.lastClickTime) + 700L;
        if (data.instantEatInteract > 0L && expectedTimeWhenEatingFinished < time) {
            data.instantEatVL *= 0.6;
        } else if (data.instantEatInteract <= time) {
            double difference = (double)(expectedTimeWhenEatingFinished - time) / 100.0;
            data.instantEatVL += difference;
            cancel = this.executeActions(player, data.instantEatVL, difference, InventoryConfig.getConfig((Player)player).instantEatActions);
        }
        data.instantEatInteract = 0L;
        data.instantEatFood = null;
        return cancel;
    }

    @Override
    protected Map<ParameterName, String> getParameterMap(ViolationData violationData) {
        Map<ParameterName, String> parameters = super.getParameterMap(violationData);
        parameters.put(ParameterName.FOOD, InventoryData.getData((Player)violationData.player).instantEatFood.toString());
        return parameters;
    }
}

