/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.AsyncCheck;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.ICaptcha;
import fr.neatmonster.nocheatplus.checks.chat.analysis.MessageLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.WordLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.LetterEngine;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text
extends AsyncCheck
implements INotifyReload {
    private LetterEngine engine = null;
    private String lastCancelledMessage = "";
    private long lastCancelledTime = 0L;
    private String lastGlobalMessage = "";
    private long lastGlobalTime = 0L;

    public Text() {
        super(CheckType.CHAT_TEXT);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Player player, String message, ICaptcha captcha, boolean isMainThread) {
        ChatData data;
        ChatConfig cc = ChatConfig.getConfig(player);
        ChatData chatData = data = ChatData.getData(player);
        synchronized (chatData) {
            return this.unsafeCheck(player, message, captcha, cc, data, isMainThread);
        }
    }

    private void init() {
        ConfigFile config = ConfigManager.getConfigFile();
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        if (this.engine != null) {
            this.engine.clear();
            api.removeComponent(this.engine);
        }
        this.engine = new LetterEngine(config);
        api.addComponent(this.engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload() {
        LetterEngine letterEngine = this.engine;
        synchronized (letterEngine) {
            this.engine.clear();
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unsafeCheck(Player player, String message, ICaptcha captcha, ChatConfig cc, ChatData data, boolean isMainThread) {
        boolean shortTermViolation;
        Map<String, Float> engMap;
        float timeWeight;
        LinkedList<String> debugParts;
        boolean debug;
        if (captcha.shouldCheckCaptcha(cc, data)) {
            captcha.checkCaptcha(player, message, cc, data, isMainThread);
            return true;
        }
        long time = System.currentTimeMillis();
        String lcMessage = message.trim().toLowerCase();
        boolean cancel = false;
        boolean bl = debug = cc.textDebug || cc.debug;
        if (debug) {
            debugParts = new LinkedList<String>();
            debugParts.add("[NoCheatPlus][chat.text] Message (" + player.getName() + "/" + message.length() + "): ");
        } else {
            debugParts = null;
        }
        data.chatFrequency.update(time);
        float score = 0.0f;
        MessageLetterCount letterCounts = new MessageLetterCount(message);
        int msgLen = message.length();
        if (letterCounts.fullCount.upperCase > msgLen / 3) {
            float wUpperCase = 0.6f * letterCounts.fullCount.getUpperCaseRatio();
            score += wUpperCase * cc.textMessageUpperCase;
        }
        if (msgLen > 4) {
            float fullRep = letterCounts.fullCount.getLetterCountRatio();
            float wRepetition = (float)msgLen / 15.0f * Math.abs(0.5f - fullRep);
            score += wRepetition * cc.textMessageLetterCount;
            float fnWords = (float)letterCounts.words.length / (float)msgLen;
            if (fnWords > 0.75f) {
                score += fnWords * cc.textMessagePartition;
            }
        }
        CombinedData cData = CombinedData.getData(player);
        long timeout = 8000L;
        if (cc.textMsgRepeatSelf != 0.0f && time - data.chatLastTime < 8000L && StringUtil.isSimilar(lcMessage, data.chatLastMessage, 0.8f)) {
            timeWeight = (float)(8000L - (time - data.chatLastTime)) / 8000.0f;
            score += cc.textMsgRepeatSelf * timeWeight;
        }
        if (cc.textMsgRepeatGlobal != 0.0f && time - this.lastGlobalTime < 8000L && StringUtil.isSimilar(lcMessage, this.lastGlobalMessage, 0.8f)) {
            timeWeight = (float)(8000L - (time - this.lastGlobalTime)) / 8000.0f;
            score += cc.textMsgRepeatGlobal * timeWeight;
        }
        if (cc.textMsgRepeatCancel != 0.0f && time - this.lastCancelledTime < 8000L && StringUtil.isSimilar(lcMessage, this.lastCancelledMessage, 0.8f)) {
            timeWeight = (float)(8000L - (time - this.lastCancelledTime)) / 8000.0f;
            score += cc.textMsgRepeatCancel * timeWeight;
        }
        if (cc.textMsgAfterJoin != 0.0f && time - cData.lastJoinTime < 8000L) {
            timeWeight = (float)(8000L - (time - cData.lastJoinTime)) / 8000.0f;
            score += cc.textMsgAfterJoin * timeWeight;
        }
        if (cc.textMsgNoMoving != 0.0f && time - cData.lastMoveTime > 8000L) {
            score += cc.textMsgNoMoving;
        }
        float wWords = 0.0f;
        float avwLen = (float)msgLen / (float)letterCounts.words.length;
        for (WordLetterCount word : letterCounts.words) {
            float wWord = 0.0f;
            int wLen = word.word.length();
            float fLenAv = Math.abs(avwLen - (float)wLen) / avwLen;
            wWord += fLenAv * cc.textMessageLengthAv;
            float fLenMsg = (float)wLen / (float)msgLen;
            wWord += fLenMsg * cc.textMessageLengthMsg;
            float notLetter = word.getNotLetterRatio();
            notLetter *= notLetter;
            wWord += notLetter * cc.textMessageNoLetter;
            wWord *= wWord;
            wWords += wWord;
        }
        score += (wWords /= (float)letterCounts.words.length);
        if (debug && score > 0.0f) {
            debugParts.add("Simple score: " + StringUtil.fdec3.format(score));
        }
        float wEngine = 0.0f;
        LetterEngine i$ = this.engine;
        synchronized (i$) {
            engMap = this.engine.process(letterCounts, player.getName(), cc, data);
            for (Float res : engMap.values()) {
                if (cc.textEngineMaximum) {
                    wEngine = Math.max(wEngine, res.floatValue());
                    continue;
                }
                wEngine += res.floatValue();
            }
        }
        float normalScore = Math.max(cc.textFreqNormMin, score += wEngine);
        data.chatFrequency.add(time, normalScore);
        float accumulated = cc.textFreqNormWeight * data.chatFrequency.score(cc.textFreqNormFactor);
        boolean normalViolation = (double)accumulated > cc.textFreqNormLevel;
        float shortTermScore = Math.max(cc.textFreqShortTermMin, score);
        data.chatShortTermFrequency.add(time, shortTermScore);
        float shortTermAccumulated = cc.textFreqShortTermWeight * data.chatShortTermFrequency.score(cc.textFreqShortTermFactor);
        boolean bl2 = shortTermViolation = shortTermAccumulated > cc.textFreqShortTermLevel;
        if (normalViolation || shortTermViolation) {
            this.lastCancelledMessage = lcMessage;
            this.lastCancelledTime = time;
            double added = shortTermViolation ? (double)(shortTermAccumulated - cc.textFreqShortTermLevel) / 3.0 : ((double)accumulated - cc.textFreqNormLevel) / 10.0;
            data.textVL += added;
            if (captcha.shouldStartCaptcha(cc, data)) {
                captcha.sendNewCaptcha(player, cc, data);
                cancel = true;
            } else if (shortTermViolation) {
                if (this.executeActions(player, data.textVL, added, cc.textFreqShortTermActions, isMainThread)) {
                    cancel = true;
                }
            } else if (normalViolation && this.executeActions(player, data.textVL, added, cc.textFreqNormActions, isMainThread)) {
                cancel = true;
            }
        } else if (cc.chatWarningCheck && time - data.chatWarningTime > cc.chatWarningTimeout && ((double)(100.0f * accumulated) / cc.textFreqNormLevel > (double)cc.chatWarningLevel || 100.0f * shortTermAccumulated / cc.textFreqShortTermLevel > cc.chatWarningLevel)) {
            player.sendMessage(ColorUtil.replaceColors(cc.chatWarningMessage));
            data.chatWarningTime = time;
        } else {
            data.textVL *= 0.95;
            if (normalScore < 2.0f * cc.textFreqNormWeight && shortTermScore < 2.0f * cc.textFreqShortTermWeight) {
                data.textVL = 0.0;
            }
        }
        if (debug) {
            LinkedList<String> keys = new LinkedList<String>(engMap.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                Float s = engMap.get(key);
                if (!(s.floatValue() > 0.0f)) continue;
                debugParts.add(key + ":" + StringUtil.fdec3.format(s));
            }
            if (wEngine > 0.0f) {
                debugParts.add("Engine score (" + (cc.textEngineMaximum ? "max" : "sum") + "): " + StringUtil.fdec3.format(wEngine));
            }
            debugParts.add("Final score: " + StringUtil.fdec3.format(score));
            debugParts.add("Normal: min=" + StringUtil.fdec3.format(cc.textFreqNormMin) + ", weight=" + StringUtil.fdec3.format(cc.textFreqNormWeight) + " => accumulated=" + StringUtil.fdec3.format(accumulated));
            debugParts.add("Short-term: min=" + StringUtil.fdec3.format(cc.textFreqShortTermMin) + ", weight=" + StringUtil.fdec3.format(cc.textFreqShortTermWeight) + " => accumulated=" + StringUtil.fdec3.format(shortTermAccumulated));
            debugParts.add("vl: " + StringUtil.fdec3.format(data.textVL));
            LogUtil.scheduleLogInfo(debugParts, " | ");
            debugParts.clear();
        }
        this.lastGlobalMessage = data.chatLastMessage = lcMessage;
        this.lastGlobalTime = data.chatLastTime = time;
        return cancel;
    }

    @Override
    protected Map<ParameterName, String> getParameterMap(ViolationData violationData) {
        Map<ParameterName, String> parameters = super.getParameterMap(violationData);
        parameters.put(ParameterName.IP, violationData.player.getAddress().toString().substring(1).split(":")[0]);
        return parameters;
    }
}

