/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.Captcha;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.Color;
import fr.neatmonster.nocheatplus.checks.chat.Commands;
import fr.neatmonster.nocheatplus.checks.chat.Logins;
import fr.neatmonster.nocheatplus.checks.chat.Relog;
import fr.neatmonster.nocheatplus.checks.chat.Text;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class ChatListener
extends CheckListener
implements INotifyReload,
JoinLeaveListener {
    private final Captcha captcha = this.addCheck(new Captcha());
    private final Color color = this.addCheck(new Color());
    private final Commands commands = this.addCheck(new Commands());
    private final Logins logins = this.addCheck(new Logins());
    private final Text text = this.addCheck(new Text());
    private final Relog relog = this.addCheck(new Relog());
    private final SimpleCharPrefixTree commandExclusions = new SimpleCharPrefixTree();
    private final SimpleCharPrefixTree chatCommands = new SimpleCharPrefixTree();

    public ChatListener() {
        super(CheckType.CHAT);
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
    }

    private void initFilters(ConfigFile config) {
        this.commandExclusions.clear();
        this.commandExclusions.feedAll(config.getStringList("checks.chat.commands.exclusions"), false, true);
        this.chatCommands.clear();
        this.chatCommands.feedAll(config.getStringList("checks.chat.commands.handleaschat"), false, true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        TickTask.requestPermissionUpdate(event.getPlayer().getName(), CheckType.CHAT);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        if (this.color.isEnabled(player)) {
            event.setMessage(this.color.check(player, event.getMessage(), false));
        }
        if (this.text.isEnabled(player) && this.text.check(player, event.getMessage(), this.captcha, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        boolean handleAsChat;
        Player player = event.getPlayer();
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        String lcMessage = event.getMessage().trim().toLowerCase();
        String alias = lcMessage.split(" ")[0].substring(1);
        String commandLabel = CommandUtil.getCommandLabel(alias, false);
        ChatConfig cc = ChatConfig.getConfig(player);
        if (cc.protectPlugins && (commandLabel.equals("plugins") || commandLabel.equals("version") || commandLabel.equals("icanhasbukkit")) && !player.hasPermission("nocheatplus.admin.plugins")) {
            player.sendMessage(cc.noCommandPermMessage);
            event.setCancelled(true);
            return;
        }
        if (cc.opInConsoleOnly && (commandLabel.equals("op") || commandLabel.equals("deop"))) {
            player.sendMessage(ChatColor.RED + "I'm sorry, but this command can't be executed in chat. Use the console instead!");
            event.setCancelled(true);
            return;
        }
        if (this.color.isEnabled(player)) {
            event.setMessage(this.color.check(player, event.getMessage(), true));
        }
        if (handleAsChat = this.chatCommands.hasPrefixWords(lcMessage = event.getMessage().trim().toLowerCase())) {
            if (this.text.isEnabled(player) && this.text.check(player, event.getMessage(), this.captcha, true)) {
                event.setCancelled(true);
            }
        } else if (!this.commandExclusions.hasPrefixWords(lcMessage) && this.commands.isEnabled(player) && this.commands.check(player, event.getMessage(), this.captcha)) {
            event.setCancelled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Player player = event.getPlayer();
        ChatConfig cc = ChatConfig.getConfig(player);
        ChatData data = ChatData.getData(player);
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        TickTask.updatePermissions();
        ChatData chatData = data;
        synchronized (chatData) {
            this.captcha.resetCaptcha(cc, data);
        }
        if (this.relog.isEnabled(player) && this.relog.unsafeLoginCheck(player, cc, data)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.relogKickMessage);
        } else if (this.logins.isEnabled(player) && this.logins.check(player, cc, data)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.loginsKickMessage);
        }
    }

    public void onReload() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
        this.text.onReload();
        this.logins.onReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerJoins(Player player) {
        ChatData data;
        ChatConfig cc = ChatConfig.getConfig(player);
        ChatData chatData = data = ChatData.getData(player);
        synchronized (chatData) {
            if (this.captcha.isEnabled(player) && this.captcha.shouldCheckCaptcha(cc, data)) {
                this.captcha.sendNewCaptcha(player, cc, data);
            }
        }
    }

    public void playerLeaves(Player player) {
    }
}

