/*
 * Decompiled with CFR 0.152.
 */
package ferd.flatLove.gui;

import ferd.flatLove.gui.GuiCreateFlatWorldExt;
import ferd.flatLove.gui.GuiFlatBlockListSlot;
import ferd.flatLove.main.BlockRestrictions;
import ferd.flatLove.main.FlatLoveMod;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockComparator;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockMushroomCap;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.gen.FlatLayerInfo;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiFlatEditLayer
extends GuiScreen {
    private final GuiCreateFlatWorldExt createFlatWorldGuiExt;
    private GuiFlatBlockListSlot blockListGui;
    private final ArrayList<FlatLayerInfo> layers;
    private int selectedLayer;
    private String title;
    private String selection;
    private String oldInfo;
    private String blockIDString;
    private String heightString;
    private String metaString;
    private GuiTextField blockIDField;
    private GuiTextField heightField;
    private GuiTextField metaField;
    private GuiTextField searchField;
    private boolean metaEnabled;
    private boolean heightEnabled;
    private RenderItem renderItem;
    private ArrayList<Map.Entry<String, ArrayList<ItemStack>>> tabsList;
    private int currentTab;
    private ArrayList<ItemStack> tabless;

    public GuiFlatEditLayer(GuiCreateFlatWorldExt par1, int par2Selected, List layers, String old, Minecraft par5Minecraft, RenderItem par6RenderItem, FontRenderer par7FontRenderer) {
        this.field_73882_e = par5Minecraft;
        this.renderItem = par6RenderItem;
        this.createFlatWorldGuiExt = par1;
        this.selectedLayer = par2Selected;
        this.setupTabs();
        this.currentTab = this.getTab(((FlatLayerInfo)layers.get(layers.size() - 1 - par2Selected)).func_82659_b(), false);
        this.layers = (ArrayList)layers;
        this.oldInfo = old;
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.title = StatCollector.func_74838_a((String)"createWorld.customize.flat.editLayer");
        this.blockIDString = FlatLoveMod.guiStrings.get("editFlatLayer.blockID");
        this.heightString = FlatLoveMod.guiStrings.get("editFlatLayer.height");
        this.metaString = FlatLoveMod.guiStrings.get("editFlatLayer.meta");
        this.field_73887_h.add(new GuiButton(0, this.field_73880_f / 2 - 155, this.field_73881_g - 28, 150, 20, StatCollector.func_74838_a((String)"gui.done")));
        this.field_73887_h.add(new GuiButton(1, this.field_73880_f / 2 + 5, this.field_73881_g - 28, 150, 20, StatCollector.func_74838_a((String)"gui.cancel")));
        this.blockIDField = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 - 90, this.field_73881_g - 50, 35, 16);
        this.heightField = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 + 20, this.field_73881_g - 50, 30, 16);
        this.metaField = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 + 123, this.field_73881_g - 50, 30, 16);
        this.blockIDField.func_73804_f(4);
        this.heightField.func_73804_f(3);
        this.metaField.func_73804_f(2);
        FlatLayerInfo fli = this.layers.get(this.layers.size() - this.selectedLayer - 1);
        int id = fli.func_82659_b();
        this.blockIDField.func_73782_a("" + id);
        this.heightField.func_73782_a("" + fli.func_82657_a());
        this.metaField.func_73782_a("" + fli.func_82658_c());
        for (int i = 0; i < this.tabsList.size(); ++i) {
            this.field_73887_h.add(new GuiButton(i + 2, this.field_73880_f / 2 - this.tabsList.size() * 20 - 35 + i * 40, 20, 35, 20, ""));
        }
        this.searchField = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 + this.tabsList.size() * 20 - 35, 22, 70, 16);
        this.setTab(this.currentTab);
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        this.blockIDField.func_73793_a(par1, par2, par3);
        if (this.heightEnabled) {
            this.heightField.func_73793_a(par1, par2, par3);
        }
        if (this.metaEnabled) {
            this.metaField.func_73793_a(par1, par2, par3);
        }
        this.searchField.func_73793_a(par1, par2, par3);
        for (int i = 2; i < this.tabsList.size() + 2; ++i) {
            boolean hover;
            GuiButton btn = (GuiButton)this.field_73887_h.get(i);
            boolean bl = hover = par1 >= btn.field_73746_c && par2 >= btn.field_73743_d && par1 < btn.field_73746_c + 35 && par2 <= btn.field_73743_d + 20;
            if (!hover) continue;
            this.setTab(i - 2);
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 200 || par2 == 208) {
            this.blockListGui.selectedSlot = this.blockListGui.selectedSlot + (par2 == 200 ? -1 : 1);
            int id = this.blockListGui.getSelectedBlockID();
            int meta = this.blockListGui.getSelectedBlockMeta();
            this.blockListGui.setSelectedBlock(id, meta);
            this.setID(id, true);
            this.setMeta(meta);
            this.searchField.func_73796_b(false);
        } else if (par2 == 28) {
            if (this.searchField.func_73806_l()) {
                this.searchField.func_73796_b(false);
                this.blockListGui.selectedSlot = 0;
                int id = this.blockListGui.getSelectedBlockID();
                int meta = this.blockListGui.getSelectedBlockMeta();
                this.blockListGui.setSelectedBlock(id, meta);
                this.setID(id, true);
                this.setMeta(meta);
            } else if (this.blockListGui.selectedSlot == -1) {
                this.blockListGui.selectedSlot = 0;
                int id = this.blockListGui.getSelectedBlockID();
                int meta = this.blockListGui.getSelectedBlockMeta();
                this.blockListGui.setSelectedBlock(id, meta);
                this.setID(id, true);
                this.setMeta(meta);
            } else if (!(this.blockIDField.func_73806_l() || this.heightField.func_73806_l() || this.metaField.func_73806_l())) {
                this.func_73875_a(new GuiButton(0, 0, 0, ""));
            } else {
                this.updateInfo();
                this.blockIDField.func_73796_b(false);
                this.heightField.func_73796_b(false);
                this.metaField.func_73796_b(false);
            }
        } else if (this.searchField.func_73802_a(par1, par2)) {
            this.searchItems(this.searchField.func_73781_b());
            this.setTab(this.tabsList.size() - 1);
        } else if ("\b0123456789".contains(par1 + "") || par2 == 211 || par2 == 203 || par2 == 205) {
            if (this.blockIDField.func_73802_a(par1, par2) || this.metaEnabled && this.metaField.func_73802_a(par1, par2)) {
                int id = 0;
                id = MathHelper.func_82714_a((String)this.blockIDField.func_73781_b(), (int)0, (int)0);
                int tab = this.getTab(id, false);
                if (tab != -1 && this.currentTab != tab) {
                    this.setTab(tab);
                }
                this.blockListGui.setSelectedBlock(id);
            } else if (!this.heightEnabled || this.heightField.func_73802_a(par1, par2)) {
                // empty if block
            }
        }
        super.func_73869_a(par1, par2);
    }

    protected void func_73875_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_73741_f == 0) {
            this.updateInfo();
            this.field_73882_e.func_71373_a((GuiScreen)this.createFlatWorldGuiExt);
        } else if (par1GuiButton.field_73741_f == 1) {
            if (this.oldInfo != "") {
                this.createFlatWorldGuiExt.setFlatGeneratorInfo(this.oldInfo);
            }
            this.field_73882_e.func_71373_a((GuiScreen)this.createFlatWorldGuiExt);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int x;
        CreativeTabs tab;
        this.func_73873_v_();
        this.blockListGui.func_77211_a(par1, par2, par3);
        this.func_73732_a(this.field_73886_k, this.title, this.field_73880_f / 2, 8, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, this.blockIDString, this.field_73880_f / 2 - 154, this.field_73881_g - 46, 0xFFFFFF);
        this.blockIDField.func_73795_f();
        int c = this.heightEnabled ? 0xFFFFFF : 0xA0A0A0;
        this.func_73731_b(this.field_73886_k, this.heightString, this.field_73880_f / 2 - 49, this.field_73881_g - 46, c);
        this.heightField.func_73794_g(c);
        c = this.metaEnabled ? 0xFFFFFF : 0xA0A0A0;
        this.func_73731_b(this.field_73886_k, this.metaString, this.field_73880_f / 2 + 55, this.field_73881_g - 46, c);
        this.metaField.func_73794_g(c);
        this.heightField.func_73795_f();
        this.metaField.func_73795_f();
        this.searchField.func_73795_f();
        this.updateItem();
        super.func_73863_a(par1, par2, par3);
        int i = 0;
        int y = 20;
        for (Map.Entry<String, ArrayList<ItemStack>> e : this.tabsList) {
            tab = this.getTabByLabel(e.getKey());
            if (tab == null || tab.func_78013_b().equals("search")) continue;
            x = this.field_73880_f / 2 - this.tabsList.size() * 20 - 35 + i++ * 40 + 7;
            this.drawItemStack(x, y, tab.getIconItemStack());
        }
        this.drawItemStack(this.field_73880_f / 2 - this.tabsList.size() * 20 - 35 + i * 40 + 7, y, CreativeTabs.field_78027_g.getIconItemStack());
        i = 0;
        for (Map.Entry<String, ArrayList<ItemStack>> e : this.tabsList) {
            tab = this.getTabByLabel(e.getKey());
            if (tab == null || tab.func_78013_b().equals("search")) continue;
            x = this.field_73880_f / 2 - this.tabsList.size() * 20 - 35 + i++ * 40;
            this.drawToolTip(new String[]{I18n.func_135053_a((String)tab.func_78024_c())}, x, y, 33, 18, par1, par2, -1);
        }
        this.drawToolTip(new String[]{I18n.func_135053_a((String)CreativeTabs.field_78027_g.func_78024_c())}, this.field_73880_f / 2 - this.tabsList.size() * 20 - 35 + i * 40, y, 33, 18, par1, par2, -1);
    }

    private CreativeTabs getTabByLabel(String tabLabel) {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (!tab.func_78013_b().equals(tabLabel)) continue;
            return tab;
        }
        return null;
    }

    private void drawToolTip(String[] toolTip, int x, int y, int w, int h, int mX, int mY, int color) {
        if (mX >= x && mX <= x + w + 1 && mY >= y && mY <= y + h + 1) {
            int tX = mX + 5;
            int i = 0;
            for (i = 0; i < toolTip.length; ++i) {
                tX = Math.min(tX, this.field_73880_f - this.field_73886_k.func_78256_a(toolTip[i]));
            }
            while (--i >= 0) {
                this.func_73731_b(this.field_73886_k, toolTip[i], tX, mY + 10 + i * 10, color);
            }
        }
    }

    public void func_73876_c() {
        this.blockIDField.func_73780_a();
        if (this.heightEnabled) {
            this.heightField.func_73780_a();
        }
        if (this.metaEnabled) {
            this.metaField.func_73780_a();
        }
        this.searchField.func_73780_a();
        super.func_73876_c();
    }

    private void updateInfo() {
        if (!this.blockListGui.isInList(MathHelper.func_82715_a((String)this.blockIDField.func_73781_b(), (int)0), MathHelper.func_82715_a((String)this.metaField.func_73781_b(), (int)0))) {
            this.setID(this.blockListGui.getSelectedBlockID(), true);
            this.setMeta(this.blockListGui.getSelectedBlockMeta());
        }
        int id = MathHelper.func_82714_a((String)this.blockIDField.func_73781_b(), (int)0, (int)0);
        int h = this.heightEnabled ? MathHelper.func_82714_a((String)this.heightField.func_73781_b(), (int)1, (int)1) : 1;
        int meta = this.metaEnabled ? MathHelper.func_82714_a((String)this.metaField.func_73781_b(), (int)0, (int)0) : 0;
        this.layers.set(this.layers.size() - this.selectedLayer - 1, new FlatLayerInfo(h, id, meta));
    }

    public void setID(int id, boolean unFocus) {
        this.blockIDField.func_73782_a(id + "");
        if (this.currentTab != this.tabsList.size() - 1) {
            this.metaField.func_73796_b(false);
        }
        if (unFocus) {
            this.heightField.func_73796_b(false);
        }
        if (unFocus) {
            this.blockIDField.func_73796_b(false);
        }
        this.updateItem();
    }

    public void updateItem() {
        ItemStack var7;
        int id = MathHelper.func_82714_a((String)this.blockIDField.func_73781_b(), (int)0, (int)0);
        int meta = 0;
        if (id >= 256 || Block.field_71973_m[id] == null) {
            return;
        }
        ItemStack itemStack = var7 = id == 0 ? null : new ItemStack(id, 1, meta);
        if (var7 == null) {
            return;
        }
        this.heightEnabled = !FlatLoveMod.CRASH_SAFE_DISABLE_HEIGHT_FIELD || !FlatLoveMod.unstableBlocks.containsKey(id) || !FlatLoveMod.unstableBlocks.get(id).maxOne();
        boolean bl = this.metaEnabled = var7.func_77973_b().func_77614_k() || FlatLoveMod.ALWAYS_META || Block.field_71973_m[id] instanceof BlockStairs || Block.field_71973_m[id] instanceof BlockMushroomCap || Block.field_71973_m[id] instanceof BlockPumpkin || Block.field_71973_m[id] instanceof BlockSnow || Block.field_71973_m[id] instanceof BlockPistonBase || Block.field_71973_m[id] instanceof BlockDispenser || Block.field_71973_m[id] instanceof BlockPumpkin || Block.field_71973_m[id] instanceof BlockEndPortalFrame || Block.field_71973_m[id] instanceof BlockRedstoneRepeater || Block.field_71973_m[id] instanceof BlockComparator || Block.field_71973_m[id] instanceof BlockFenceGate || Block.field_71973_m[id] instanceof BlockFurnace || Block.field_71973_m[id] instanceof BlockHopper || Block.field_71973_m[id] instanceof BlockLever || Block.field_71973_m[id] instanceof BlockRailBase || Block.field_71973_m[id] instanceof BlockCake;
        if (this.metaEnabled) {
            meta = MathHelper.func_82714_a((String)this.metaField.func_73781_b(), (int)0, (int)0);
        }
    }

    private void setTab(int id) {
        for (int i = 2; i < this.tabsList.size() + 2; ++i) {
            ((GuiButton)this.field_73887_h.get((int)i)).field_73742_g = false;
        }
        if (id == -1) {
            id = this.tabsList.size() - 1;
        }
        ((GuiButton)this.field_73887_h.get((int)(id + 2))).field_73742_g = true;
        String name = this.tabsList.get(id).getKey();
        if (MathHelper.func_76139_a((String)name)) {
            return;
        }
        this.blockListGui = new GuiFlatBlockListSlot(this, this.field_73882_e, this.renderItem, this.field_73886_k, this.getBlocksInTab(id), id != this.tabsList.size() - 1);
        this.blockListGui.func_77207_a(this.field_73880_f, this.field_73881_g, 43, this.field_73881_g - 60);
        this.blockListGui.setSelectedBlock(MathHelper.func_82714_a((String)this.blockIDField.func_73781_b(), (int)0, (int)0), MathHelper.func_82714_a((String)this.metaField.func_73781_b(), (int)0, (int)0));
        this.setID(this.blockListGui.getSelectedBlockID(), false);
        this.currentTab = id;
    }

    private void setupTabs() {
        this.tabless = new ArrayList();
        this.tabsList = new ArrayList();
        this.tabsList.add(new AbstractMap.SimpleEntry("search", new ArrayList()));
        ArrayList<ItemStack> blocks = new ArrayList<ItemStack>();
        for (int i = 0; i < Block.field_71973_m.length; ++i) {
            Block block = Block.field_71973_m[i];
            if (block == null || block.field_71990_ca == 0 || FlatLoveMod.CRASH_SAFE_REMOVE_BLOCKS > 0 && FlatLoveMod.unstableBlocks.containsKey(block.field_71990_ca) && (FlatLoveMod.unstableBlocks.get(block.field_71990_ca) == BlockRestrictions.CRASH || FlatLoveMod.CRASH_SAFE_REMOVE_BLOCKS > 1)) continue;
            blocks.add(new ItemStack(block));
        }
        for (ItemStack is : blocks) {
            if (is == null) continue;
            int tab = this.getTab(is.field_77993_c, true);
            if (tab == -1) {
                this.tabless.add(is);
                this.tabsList.get(this.tabsList.size() - 1).getValue().add(is);
                continue;
            }
            ArrayList<ItemStack> subs = this.getSubItemList(is);
            if (subs != null) {
                for (ItemStack i : subs) {
                    this.tabsList.get(this.tabsList.size() - 1).getValue().add(i);
                }
                continue;
            }
            this.tabsList.get(this.tabsList.size() - 1).getValue().add(is);
        }
        this.tabsList.get(this.tabsList.size() - 1).getValue().add(0, null);
        this.tabsList.get(0).getValue().add(0, null);
    }

    private ArrayList<ItemStack> getBlocksInTab(int tab) {
        if (this.tabsList == null) {
            this.setupTabs();
        }
        if (tab < 0 || tab >= this.tabsList.size()) {
            return null;
        }
        return this.tabsList.get(tab).getValue();
    }

    public ArrayList<ItemStack> getSubItemList(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack block = itemStack.func_77946_l();
        if (block == null) {
            return null;
        }
        block.func_77964_b(0);
        ArrayList<ItemStack> list = null;
        if (block.func_77981_g()) {
            list = new ArrayList<ItemStack>();
            list.add(block);
            ItemStack stack = block.func_77946_l();
            while (stack.func_77960_j() < 15) {
                stack = new ItemStack(block.field_77993_c, stack.field_77994_a + 1, stack.func_77960_j() + 1);
                boolean add = true;
                for (ItemStack is : list) {
                    if (stack.func_77954_c() != is.func_77954_c()) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                list.add(stack);
            }
            if (block.field_77993_c == Block.field_71951_J.field_71990_ca) {
                list.remove(list.size() - 1);
            } else if (block.field_77993_c == Block.field_71952_K.field_71990_ca) {
                list.add(2, new ItemStack(block.field_77993_c, 1, 2));
            } else if (block.field_77993_c == Block.field_82510_ck.field_71990_ca) {
                list.add(new ItemStack(block.field_77993_c, 1, 4));
                list.add(new ItemStack(block.field_77993_c, 1, 8));
            }
        }
        return list;
    }

    private void drawItemStack(int par1, int par2, ItemStack par3ItemStack) {
        if (par3ItemStack == null) {
            return;
        }
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        this.renderItem.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, par3ItemStack, par1 + 2, par2 + 2);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }

    public int getMeta() {
        int meta = MathHelper.func_82714_a((String)this.metaField.func_73781_b(), (int)0, (int)0);
        return meta;
    }

    public void setMeta(int m) {
        String meta = m + "";
        if (!meta.matches("[0123456789]*")) {
            return;
        }
        this.metaField.func_73782_a(meta);
    }

    public void searchItems(String s) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry<String, ArrayList<ItemStack>> e : this.tabsList) {
            if (e.getKey() == "search") continue;
            for (ItemStack is : e.getValue()) {
                ArrayList<ItemStack> subs = this.getSubItemList(is);
                if (subs != null) {
                    for (ItemStack i : subs) {
                        String n = this.createFlatWorldGuiExt.getItemName(i);
                        if (n.toLowerCase().contains(s.toLowerCase())) {
                            list.add(i);
                            continue;
                        }
                        if (!(is.field_77993_c + "").contains(s)) continue;
                        list.add(i);
                    }
                    continue;
                }
                String name = this.createFlatWorldGuiExt.getItemName(is);
                if (name.toLowerCase().contains(s.toLowerCase())) {
                    list.add(is);
                    continue;
                }
                int id = is == null ? 0 : is.field_77993_c;
                if (!(id + "").contains(s)) continue;
                list.add(is);
            }
        }
        for (ItemStack is : this.tabless) {
            ArrayList<ItemStack> subs = this.getSubItemList(is);
            if (subs != null) {
                for (ItemStack i : subs) {
                    String n = this.createFlatWorldGuiExt.getItemName(i);
                    if (n.toLowerCase().contains(s.toLowerCase())) {
                        list.add(i);
                        continue;
                    }
                    if (!(is.field_77993_c + "").contains(s)) continue;
                    list.add(i);
                }
                continue;
            }
            String n = this.createFlatWorldGuiExt.getItemName(is);
            if (n.toLowerCase().contains(s.toLowerCase())) {
                list.add(is);
                continue;
            }
            if (!((is == null ? 0 : is.field_77993_c) + "").contains(s)) continue;
            list.add(is);
        }
        this.tabsList.get(this.tabsList.size() - 1).setValue(list);
    }

    private int getTab(int id, boolean add) {
        String tab = null;
        if (id < 0 || id >= Item.field_77698_e.length || Item.field_77698_e[id] == null) {
            return -1;
        }
        ItemStack is = new ItemStack(Item.field_77698_e[id]);
        if (is != null && is.func_77973_b() != null && is.func_77973_b().func_77640_w() != null) {
            tab = is.func_77973_b().func_77640_w().func_78013_b();
        }
        if (tab == null) {
            for (Map.Entry<String, ArrayList<Integer>> e : FlatLoveMod.tabs.entrySet()) {
                if (e.getValue().contains(id)) {
                    tab = e.getKey();
                    break;
                }
                if (tab == null) continue;
                break;
            }
        }
        if (tab == null) {
            return -1;
        }
        if (add) {
            boolean contains = false;
            for (Map.Entry<String, ArrayList<ItemStack>> e : this.tabsList) {
                if (!e.getKey().equals(tab)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.tabsList.add(this.tabsList.size() - 1, new AbstractMap.SimpleEntry(tab, new ArrayList()));
            }
            for (Map.Entry<String, ArrayList<ItemStack>> e : this.tabsList) {
                if (!e.getKey().equals(tab)) continue;
                if (e.getValue().contains(is)) break;
                e.getValue().add(is);
                break;
            }
        }
        for (int i = 0; i < this.tabsList.size(); ++i) {
            if (!this.tabsList.get(i).getKey().equals(tab)) continue;
            return i;
        }
        return -1;
    }

    public String getItemName(ItemStack is) {
        return this.createFlatWorldGuiExt.getItemName(is);
    }
}

