/*
 * Decompiled with CFR 0.152.
 */
package ferd.flatLove.main;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import ferd.flatLove.gui.GuiFlatEditFeatures;
import ferd.flatLove.gui.GuiFlatPresetsExt;
import ferd.flatLove.gui.GuiFlatPresetsItemExt;
import ferd.flatLove.main.BlockRestrictions;
import ferd.flatLove.main.FeatureParameter;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;

public class FlatLoveMod
extends DummyModContainer {
    private static final int MAX_FEATURES = 14;
    private static File presetsFile;
    public static boolean DRAW_LAYER_BAR;
    public static boolean DRAW_TOOLTIP_BIOME;
    public static boolean DRAW_TOOLTIP_PARAM;
    public static boolean DRAW_TOOLTIP_SUBTYPES;
    public static boolean ALWAYS_META;
    public static boolean CRASH_SAFE_DISABLE_HEIGHT_FIELD;
    public static int CRASH_SAFE_WARN_BLOCKS;
    public static int CRASH_SAFE_REMOVE_BLOCKS;
    public static ArrayList<Map.Entry<String, String>> featureNames;
    public static HashMap<String, ArrayList<FeatureParameter>> featureParams;
    public static HashMap<String, String> guiStrings;
    public static HashMap<Integer, BlockRestrictions> unstableBlocks;
    public static ArrayList<Map.Entry<String, String>> customFeats;
    public static HashMap<String, ArrayList<FeatureParameter>> customParams;
    public static HashMap<String, Object> customGenerators;
    public static HashMap<String, ArrayList<Integer>> tabs;

    public FlatLoveMod() {
        super(new ModMetadata());
        ModMetadata meta = super.getMetadata();
        meta.modId = "flatLoveByFerd";
        meta.authorList = Arrays.asList("Ferd");
        meta.version = "1.4";
        meta.name = "Flat Love";
        meta.description = "Adds missing functionality to the Flatworld creation interface.";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        ArrayList<FeatureParameter> params;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        DRAW_LAYER_BAR = config.get("general", "draw_layer_bar", true, "Display the layers as a bar next to the list").getBoolean(true);
        DRAW_TOOLTIP_BIOME = config.get("general", "draw_tooltip_biome", true, "Show a tooltip with all the available biomes and their ID").getBoolean(true);
        DRAW_TOOLTIP_PARAM = config.get("general", "draw_tooltip_param", true, "Show a tooltip with the parameters and their value when hovering over the Params button").getBoolean(true);
        DRAW_TOOLTIP_SUBTYPES = config.get("general", "draw_tooltip_subtypes", true, "Show the available subtypes of a block when hovering over it in the selection list").getBoolean(true);
        ALWAYS_META = config.get("general", "always_meta", false, "Always show the Meta field, even for Blocks without subtypes").getBoolean(false);
        CRASH_SAFE_DISABLE_HEIGHT_FIELD = config.get("general" + ".crash_safe", "crash_safe_disable_height_field", true, "Disables the height field for blocks that crash the game when the layer height is greater than 1.").getBoolean(true);
        CRASH_SAFE_REMOVE_BLOCKS = config.get("general" + ".crash_safe", "crash_safe_remove_blocks", 1, "This will remove blocks from the list, that will or might crash the game.\n\t0:\tRemove no blocks\n\t1:\tRemove only blocks that WILL crash\n\t2:\tRemove all unstable blocks (boring!)").getInt(1);
        CRASH_SAFE_WARN_BLOCKS = config.get("general" + ".crash_safe", "crash_safe_remove_crash_blocks", 2, "This will add a warning to blocks from the list, that will or might crash the game.\n\t0:\tWarn of no blocks\n\t1:\tWarn of only blocks that WILL crash\n\t2:\tWarn of all unstable blocks").getInt(2);
        if (CRASH_SAFE_WARN_BLOCKS >= 1 || CRASH_SAFE_REMOVE_BLOCKS >= 1) {
            this.addUnstableBlocks();
        }
        config.save();
        Configuration strings = new Configuration(new File(event.getModConfigurationDirectory(), event.getModMetadata().modId + "_strings.cfg"));
        strings.load();
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("village", "Villages"));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("biome_1", "Temples etc."));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("mineshaft", "Mineshafts"));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("stronghold", "Strongholds"));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("decoration", "Ores, Trees, Grass etc."));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("lake", "Lakes"));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("lava_lake", "Lava lakes"));
        featureNames.add(new AbstractMap.SimpleEntry<String, String>("dungeon", "Dungeons"));
        ArrayList<FeatureParameter> paramsVillage = new ArrayList<FeatureParameter>();
        ArrayList<FeatureParameter> paramsBiome_1 = new ArrayList<FeatureParameter>();
        ArrayList<FeatureParameter> paramsMineshaft = new ArrayList<FeatureParameter>();
        ArrayList<FeatureParameter> paramsStronghold = new ArrayList<FeatureParameter>();
        paramsVillage.add(new FeatureParameter("size", "Size", "1", "The size of the village,; minimum 0 (default),; 1 is superflat default"));
        paramsVillage.add(new FeatureParameter("distance", "Distance", "32", "Chunks between the villages,; minimum 9"));
        paramsBiome_1.add(new FeatureParameter("distance", "Distance", "32", "Chunks between Scattered Features,; e.g., Tempels, Pyramids and Swamphuts,; minimum 9"));
        paramsMineshaft.add(new FeatureParameter("chance", "Chance", "0.01", "How common mineshafts are,; should be between 0.0 and 1.0"));
        paramsStronghold.add(new FeatureParameter("count", "Count", "3", "How many per world exist,; minimum 1"));
        paramsStronghold.add(new FeatureParameter("distance", "Distance", "32", "The distance from 0/0 in chunks,; minimum 1.0"));
        paramsStronghold.add(new FeatureParameter("spread", "Spread", "3", "How they are spread over a circle,; needs to be equal to count for; a perfect circle,; minimum 1"));
        featureParams.put("village", paramsVillage);
        featureParams.put("biome_1", paramsBiome_1);
        featureParams.put("mineshaft", paramsMineshaft);
        featureParams.put("stronghold", paramsStronghold);
        for (Map.Entry<String, String> entry : featureNames) {
            entry.setValue(strings.get("feature.names", entry.getKey(), entry.getValue()).getString());
        }
        for (Map.Entry<String, Object> entry : featureParams.entrySet()) {
            params = (ArrayList<FeatureParameter>)entry.getValue();
            for (FeatureParameter param : params) {
                param.name = strings.get("feature.params." + entry.getKey(), entry.getKey() + "." + param.param + ".name", param.name).getString();
                param.value = strings.get("feature.params." + entry.getKey(), entry.getKey() + "." + param.param + ".value", param.value).getString();
                param.hint = strings.get("feature.params." + entry.getKey(), entry.getKey() + "." + param.param + ".hint", param.hint).getString();
            }
        }
        strings.addCustomCategoryComment("feature.custom", "If you have a mod that adds some features to superflat worlds, you can add them here.");
        strings.addCustomCategoryComment("feature.custom.names", "Add the feature code name and a readable name here like so:\n\tS:<code name>=<name>\nCurrently a maximum of 6 additional features is supported.");
        strings.addCustomCategoryComment("feature.custom.params", "If your feature has parameters, add them here. \nThey need to be a category with the same name as the feature they belong to.\nThey also need a hint, a name and a default value.\n Add them like this:\n<feature name> {\n\tS:<feature name>.<parameter>.hint=<hint>\n\tS:<feature name>.<parameter>.name=<name>\n\tS:<feature name>.<parameter>.value=<default value>\n}");
        for (Map.Entry<String, Object> entry : customFeats) {
            entry.setValue(strings.get("feature.custom.names", entry.getKey(), (String)entry.getValue()).getString());
            if (!customParams.containsKey(entry.getKey())) continue;
            params = customParams.get(entry.getKey());
            for (FeatureParameter param : params) {
                param.hint = strings.get("feature.custom.params." + entry.getKey(), entry.getKey() + "." + param.param + ".hint", param.hint).getString();
                param.defValue = param.value = strings.get("feature.custom.params." + entry.getKey(), entry.getKey() + "." + param.param + ".value", param.value).getString();
                param.name = strings.get("feature.custom.params." + entry.getKey(), entry.getKey() + "." + param.param + ".name", param.name).getString();
            }
        }
        featureNames.addAll(customFeats);
        while (featureNames.size() > 14) {
            featureNames.remove(featureNames.size() - 1);
        }
        featureParams.putAll(customParams);
        GuiFlatEditFeatures.features = featureNames;
        GuiFlatEditFeatures.params = featureParams;
        guiStrings.put("createWorld.customize.features", "Features");
        guiStrings.put("createWorld.customize.warning.layerCount", "This will crash your game. Maximum Layer count is 256.");
        guiStrings.put("createWorld.customize.warning.crash", "The block of layer %d will crash your game.");
        guiStrings.put("createWorld.customize.warning.crash2", "The block of layer %d will probably crash your game.");
        guiStrings.put("createWorld.customize.warning.lag", "The block of layer %d might cause (severe) lags.");
        guiStrings.put("createWorld.customize.warning.idToHigh", "Layer %d has a too high ID (%d). It will be replaced by %s.");
        guiStrings.put("editFlatLayer.selection", "Selection:");
        guiStrings.put("editFlatLayer.blockID", "Block ID:");
        guiStrings.put("editFlatLayer.height", "Height:");
        guiStrings.put("editFlatLayer.meta", "Meta:");
        guiStrings.put("createWorld.customize.biome", "Biome:");
        guiStrings.put("flatPresets.add", "Add");
        guiStrings.put("flatPresets.edit", "Edit");
        guiStrings.put("flatPresets.delete", "Delete");
        guiStrings.put("flatPresets.restore", "Restore");
        guiStrings.put("flatPresets.newPreset", "New Preset");
        guiStrings.put("flatPresets.addPreset", "Add Preset");
        guiStrings.put("flatPresets.editPreset", "Edit Preset");
        guiStrings.put("flatPresets.item.name", "Name:");
        guiStrings.put("flatPresets.item.icon", "Icon:");
        guiStrings.put("flatPresets.item.id", "ID:");
        guiStrings.put("flatPresets.item.preset", "Preset:");
        guiStrings.put("block.air.name", "Air");
        guiStrings.put("block.endPortal.name", "End Portal");
        guiStrings.put("block.pistonMoving.name", "Piston Moving");
        for (Map.Entry<String, Object> entry : guiStrings.entrySet()) {
            entry.setValue(strings.get("strings.gui", entry.getKey(), (String)entry.getValue()).getString());
        }
        strings.save();
        this.setTabs();
        presetsFile = new File(event.getModConfigurationDirectory(), event.getModMetadata().modId + "_presets.cfg");
        Configuration presets = new Configuration(presetsFile, true);
        presets.load();
        ConfigCategory configCategory = presets.getCategory("presets");
        for (ConfigCategory cats : configCategory.getChildren()) {
            GuiFlatPresetsExt.addPreset(cats.getQualifiedName().substring(cats.getQualifiedName().lastIndexOf(46) + 1), cats.get("icon").getInt(1), cats.get("preset").getString());
        }
        presets.save();
        if (GuiFlatPresetsExt.getPresets().isEmpty()) {
            FlatLoveMod.restorePresetDefaults();
        }
    }

    private void setTabs() {
        ArrayList<Integer> misc = new ArrayList<Integer>();
        misc.addAll(Arrays.asList(Block.field_71942_A.field_71990_ca, Block.field_71943_B.field_71990_ca, Block.field_71944_C.field_71990_ca, Block.field_71938_D.field_71990_ca, Block.field_72067_ar.field_71990_ca, Block.field_72065_as.field_71990_ca));
        ArrayList<Integer> redstone = new ArrayList<Integer>();
        redstone.addAll(Arrays.asList(Block.field_72095_ac.field_71990_ca, Block.field_72099_aa.field_71990_ca, Block.field_72075_av.field_71990_ca, Block.field_72049_aP.field_71990_ca, Block.field_72011_bi.field_71990_ca, Block.field_72010_bh.field_71990_ca, Block.field_72080_bM.field_71990_ca, Block.field_82517_cc.field_71990_ca, Block.field_94346_cn.field_71990_ca, Block.field_94343_co.field_71990_ca));
        ArrayList<Integer> deco = new ArrayList<Integer>();
        deco.addAll(Arrays.asList(Block.field_72058_az.field_71990_ca, Block.field_72052_aC.field_71990_ca, Block.field_72053_aD.field_71990_ca, Block.field_72042_aI.field_71990_ca, Block.field_72054_aE.field_71990_ca, Block.field_72045_aL.field_71990_ca, Block.field_72009_bg.field_71990_ca, Block.field_72004_bj.field_71990_ca, Block.field_72094_bD.field_71990_ca, Block.field_72106_bF.field_71990_ca, Block.field_72108_bG.field_71990_ca, Block.field_72102_bH.field_71990_ca, Block.field_72015_be.field_71990_ca, Block.field_72084_bK.field_71990_ca, Block.field_72062_bU.field_71990_ca, Block.field_82516_cf.field_71990_ca, Block.field_82513_cg.field_71990_ca, Block.field_82514_ch.field_71990_ca, Block.field_72040_aX.field_71990_ca, Block.field_71996_bs.field_71990_ca, Block.field_71999_bt.field_71990_ca, Block.field_72086_bP.field_71990_ca, Block.field_82512_cj.field_71990_ca, Block.field_71959_S.field_71990_ca));
        ArrayList<Integer> block = new ArrayList<Integer>();
        block.addAll(Arrays.asList(Block.field_72050_aA.field_71990_ca, Block.field_72048_aO.field_71990_ca, Block.field_72000_bn.field_71990_ca, Block.field_72001_bo.field_71990_ca, 0));
        tabs.put(CreativeTabs.field_78026_f.func_78013_b(), misc);
        tabs.put(CreativeTabs.field_78028_d.func_78013_b(), redstone);
        tabs.put(CreativeTabs.field_78031_c.func_78013_b(), deco);
        tabs.put(CreativeTabs.field_78030_b.func_78013_b(), block);
    }

    private void addUnstableBlocks() {
        unstableBlocks.put(Block.field_71959_S.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72099_aa.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(BlockPistonExtension.field_72054_aE.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72055_aF.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72045_aL.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72034_aR.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72040_aX.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72015_be.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72005_bk.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_71996_bs.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_71999_bt.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_71998_bu.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72086_bP.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72064_bT.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_82511_ci.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72038_aV.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_72040_aX.field_71990_ca, BlockRestrictions.CRASH);
        unstableBlocks.put(Block.field_111031_cC.field_71990_ca, BlockRestrictions.NEED_BELOW);
        unstableBlocks.put(Block.field_72053_aD.field_71990_ca, BlockRestrictions.NEED_SOLID_BELOW);
        unstableBlocks.put(Block.field_72042_aI.field_71990_ca, BlockRestrictions.NEED_SOLID_BELOW);
        unstableBlocks.put(Block.field_72009_bg.field_71990_ca, BlockRestrictions.NEED_SOLID_BELOW);
        unstableBlocks.put(Block.field_71962_X.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_71961_Y.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72069_aq.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72067_ar.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72075_av.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72044_aK.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72046_aM.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72049_aP.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72035_aQ.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72037_aS.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72011_bi.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72010_bh.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72062_bU.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_94348_cl.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_94345_cm.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_94346_cn.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_94343_co.field_71990_ca, BlockRestrictions.MAX_ONE_AND_SOLID_BELOW);
        unstableBlocks.put(Block.field_72043_aJ.field_71990_ca, BlockRestrictions.LEVER);
        unstableBlocks.put(Block.field_72056_aG.field_71990_ca, BlockRestrictions.RAILS);
        unstableBlocks.put(Block.field_71953_U.field_71990_ca, BlockRestrictions.POWEREDRAILS);
        unstableBlocks.put(Block.field_71954_T.field_71990_ca, BlockRestrictions.POWEREDRAILS);
        unstableBlocks.put(Block.field_94337_cv.field_71990_ca, BlockRestrictions.POWEREDRAILS);
        unstableBlocks.put(Block.field_72109_af.field_71990_ca, BlockRestrictions.SHROOMS);
        unstableBlocks.put(Block.field_72103_ag.field_71990_ca, BlockRestrictions.SHROOMS);
        unstableBlocks.put(Block.field_72058_az.field_71990_ca, BlockRestrictions.CROPS);
        unstableBlocks.put(Block.field_82514_ch.field_71990_ca, BlockRestrictions.CROPS);
        unstableBlocks.put(Block.field_82513_cg.field_71990_ca, BlockRestrictions.CROPS);
        unstableBlocks.put(Block.field_71987_y.field_71990_ca, BlockRestrictions.PLANTS);
        unstableBlocks.put(Block.field_72107_ae.field_71990_ca, BlockRestrictions.PLANTS);
        unstableBlocks.put(Block.field_72097_ad.field_71990_ca, BlockRestrictions.PLANTS);
        unstableBlocks.put(Block.field_72094_bD.field_71990_ca, BlockRestrictions.WARTS);
        unstableBlocks.put(Block.field_72077_au.field_71990_ca, BlockRestrictions.LAG);
        unstableBlocks.put(Block.field_72102_bH.field_71990_ca, BlockRestrictions.LAG);
        unstableBlocks.put(Block.field_72096_bE.field_71990_ca, BlockRestrictions.LAG);
        unstableBlocks.put(Block.field_82518_cd.field_71990_ca, BlockRestrictions.LAG);
        unstableBlocks.put(Block.field_94347_ck.field_71990_ca, BlockRestrictions.LAG);
        unstableBlocks.put(Block.field_94340_cs.field_71990_ca, BlockRestrictions.LAG);
    }

    public static void addFeature(String feature, String name, MapGenBase generator) {
        customFeats.add(new AbstractMap.SimpleEntry<String, String>(feature, name));
        customGenerators.put(feature, generator);
    }

    public static void addGenerator(String feature, String name, WorldGenerator generator) {
        customFeats.add(new AbstractMap.SimpleEntry<String, String>(feature, name));
        customGenerators.put(feature, generator);
    }

    public static void addParam(String feature, String param, String name, String value, String hint) {
        ArrayList<Object> params;
        if (!customParams.containsKey(feature)) {
            params = new ArrayList();
            customParams.put(feature, params);
        } else {
            params = customParams.get(feature);
        }
        params.add(new FeatureParameter(param, name, value, hint));
    }

    public static void savePresets() {
        if (presetsFile == null || !presetsFile.exists()) {
            return;
        }
        Configuration presetConfig = new Configuration(presetsFile, true);
        presetConfig.load();
        presetConfig.removeCategory(presetConfig.getCategory("presets"));
        List list = GuiFlatPresetsExt.getPresets();
        for (GuiFlatPresetsItemExt pre : list) {
            while (presetConfig.hasCategory("presets." + pre.presetName)) {
                pre.presetName = pre.presetName + "_";
            }
            presetConfig.get("presets." + pre.presetName, "icon", pre.iconId);
            presetConfig.get("presets." + pre.presetName, "preset", pre.presetData);
        }
        presetConfig.save();
    }

    public static void restorePresetDefaults() {
        List presets = GuiFlatPresetsExt.getPresets();
        presets.clear();
        presets.add(new GuiFlatPresetsItemExt(2, "Classic Flat", "2;7,2x3,2;1;village"));
        presets.add(new GuiFlatPresetsItemExt(1, "Tunnelers' Dream", "2;7,230x1,5x3,2;3;stronghold,biome_1,decoration,dungeon,mineshaft"));
        presets.add(new GuiFlatPresetsItemExt(8, "Water World", "2;7,5x1,5x3,5x12,90x9;1;biome_1,village"));
        presets.add(new GuiFlatPresetsItemExt(31, "Overworld", "2;7,59x1,3x3,2;1;stronghold,biome_1,village,decoration,dungeon,lake,mineshaft,lava_lake"));
        presets.add(new GuiFlatPresetsItemExt(78, "Snowy Kingdom", "2;7,59x1,3x3,2,78;12;biome_1,village"));
        presets.add(new GuiFlatPresetsItemExt(288, "Bottomless Pit", "2;2x4,3x3,2;1;biome_1,village"));
        presets.add(new GuiFlatPresetsItemExt(331, "Redstone Ready", "2;7,3x1,52x24;2;"));
        FlatLoveMod.savePresets();
    }

    static {
        featureNames = new ArrayList();
        featureParams = new HashMap();
        guiStrings = new HashMap();
        unstableBlocks = new HashMap();
        customFeats = new ArrayList();
        customParams = new HashMap();
        customGenerators = new HashMap();
        tabs = new HashMap();
    }
}

