/*
 * Decompiled with CFR 0.152.
 */
package ferd.flatLove.main;

import ferd.flatLove.main.FlatLoveMod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.MapGenScatteredFeature;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkProviderFlatExt
implements IChunkProvider {
    private World worldObj;
    private Random random;
    private final byte[] field_82700_c = new byte[256];
    private final byte[] field_82698_d = new byte[256];
    private final FlatGeneratorInfo field_82699_e;
    private final List structureGenerators = new ArrayList();
    private final ArrayList<MapGenBase> customFeatures = new ArrayList();
    private final ArrayList<WorldGenerator> customGenerators = new ArrayList();
    private final boolean field_82697_g;
    private final boolean field_82702_h;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;

    public ChunkProviderFlatExt(World par1World, long par2, boolean par4, String par5Str) {
        this.worldObj = par1World;
        this.random = new Random(par2);
        this.field_82699_e = FlatGeneratorInfo.func_82651_a((String)par5Str);
        if (par4) {
            Map map = this.field_82699_e.func_82644_b();
            if (map.containsKey("village")) {
                Map map1 = (Map)map.get("village");
                if (!map1.containsKey("size")) {
                    map1.put("size", "1");
                }
                this.structureGenerators.add(new MapGenVillage(map1));
            }
            if (map.containsKey("biome_1")) {
                this.structureGenerators.add(new MapGenScatteredFeature((Map)map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.structureGenerators.add(new MapGenMineshaft((Map)map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.structureGenerators.add(new MapGenStronghold((Map)map.get("stronghold")));
            }
            for (Map.Entry<String, Object> entry : FlatLoveMod.customGenerators.entrySet()) {
                if (!map.containsKey(entry.getKey())) continue;
                if (entry.getValue() instanceof MapGenBase) {
                    MapGenBase base = (MapGenBase)entry.getValue();
                    if (base instanceof MapGenStructure) {
                        this.structureGenerators.add((MapGenStructure)base);
                    } else {
                        this.customFeatures.add(base);
                    }
                } else {
                    if (!(entry.getValue() instanceof WorldGenerator)) continue;
                    this.customGenerators.add((WorldGenerator)entry.getValue());
                }
                if (!FlatLoveMod.customParams.containsKey(entry.getKey())) continue;
                Class<?> c = entry.getValue().getClass();
                try {
                    Method method = c.getDeclaredMethod("setMap", Map.class);
                    method.invoke(entry.getValue(), (Map)map.get(entry.getKey()));
                }
                catch (Exception e) {
                    System.err.println("Custom feature generators with parameters must \nprovide a public void setMap(Map) method. ");
                }
            }
        }
        this.field_82697_g = this.field_82699_e.func_82644_b().containsKey("decoration");
        if (this.field_82699_e.func_82644_b().containsKey("lake")) {
            this.waterLakeGenerator = new WorldGenLakes(Block.field_71943_B.field_71990_ca);
        }
        if (this.field_82699_e.func_82644_b().containsKey("lava_lake")) {
            this.lavaLakeGenerator = new WorldGenLakes(Block.field_71938_D.field_71990_ca);
        }
        this.field_82702_h = this.field_82699_e.func_82644_b().containsKey("dungeon");
        for (FlatLayerInfo flatlayerinfo : this.field_82699_e.func_82650_c()) {
            for (int j = flatlayerinfo.func_82656_d(); j < flatlayerinfo.func_82656_d() + flatlayerinfo.func_82657_a(); ++j) {
                this.field_82700_c[j] = (byte)(flatlayerinfo.func_82659_b() & 0xFF);
                this.field_82698_d[j] = (byte)flatlayerinfo.func_82658_c();
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        int h = 256;
        byte[] bytes = new byte[256 * h];
        byte[] meta = new byte[256 * h];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int ind = (x * 16 + z) * h + y;
                    bytes[ind] = this.field_82700_c[y];
                    meta[ind] = this.field_82698_d[y];
                }
            }
        }
        for (MapGenBase feature : this.customFeatures) {
            feature.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, bytes);
        }
        Chunk chunk = new Chunk(this.worldObj, par1, par2);
        for (int y = 0; y < this.field_82700_c.length; ++y) {
            int l = y >> 4;
            ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
            if (extendedblockstorage == null) {
                chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(y, !this.worldObj.field_73011_w.field_76576_e);
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    extendedblockstorage.func_76655_a(x, y & 0xF, z, bytes[(x * 16 + z) * h + y] & 0xFF);
                    extendedblockstorage.func_76654_b(x, y & 0xF, z, (int)meta[(x * 16 + z) * h + y]);
                }
            }
        }
        ExtendedBlockStorage[] ebs = chunk.func_76587_i();
        chunk.func_76603_b();
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int k1 = 0; k1 < abyte.length; ++k1) {
            abyte[k1] = (byte)abiomegenbase[k1].field_76756_M;
        }
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, (byte[])null);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int i2;
        int l1;
        int k = par2 * 16;
        int l = par3 * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        boolean flag = false;
        this.random.setSeed(this.worldObj.func_72905_C());
        long i1 = this.random.nextLong() / 2L * 2L + 1L;
        long j1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)par2 * i1 + (long)par3 * j1 ^ this.worldObj.func_72905_C());
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            boolean flag1 = mapgenstructure.func_75051_a(this.worldObj, this.random, par2, par3);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            l1 = k + this.random.nextInt(16) + 8;
            int k1 = this.random.nextInt(128);
            i2 = l + this.random.nextInt(16) + 8;
            this.waterLakeGenerator.func_76484_a(this.worldObj, this.random, l1, k1, i2);
        }
        if (this.lavaLakeGenerator != null && !flag && this.random.nextInt(8) == 0) {
            l1 = k + this.random.nextInt(16) + 8;
            int k1 = this.random.nextInt(this.random.nextInt(120) + 8);
            i2 = l + this.random.nextInt(16) + 8;
            if (k1 < 63 || this.random.nextInt(10) == 0) {
                this.lavaLakeGenerator.func_76484_a(this.worldObj, this.random, l1, k1, i2);
            }
        }
        if (this.field_82702_h) {
            for (l1 = 0; l1 < 8; ++l1) {
                int k1 = k + this.random.nextInt(16) + 8;
                i2 = this.random.nextInt(128);
                int j2 = l + this.random.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(this.worldObj, this.random, k1, i2, j2);
            }
        }
        if (this.field_82697_g) {
            biomegenbase.func_76728_a(this.worldObj, this.random, k, l);
        }
        for (WorldGenerator gen : this.customGenerators) {
            int k1 = k + this.random.nextInt(16) + 8;
            i2 = this.random.nextInt(128);
            int j2 = l + this.random.nextInt(16) + 8;
            gen.func_76484_a(this.worldObj, this.random, k1, i2, j2);
        }
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "FlatLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_73150_a(World par1World, String par2Str, int par3, int par4, int par5) {
        if ("Stronghold".equals(par2Str)) {
            for (MapGenStructure mapgenstructure : this.structureGenerators) {
                if (!(mapgenstructure instanceof MapGenStronghold)) continue;
                return mapgenstructure.func_75050_a(par1World, par3, par4, par5);
            }
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, (byte[])null);
        }
    }
}

