/*
 * Decompiled with CFR 0.152.
 */
package ferd.flatLove.main;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.world.gen.FlatLayerInfo;

public enum BlockRestrictions {
    CRASH(false),
    LAG(true),
    NEED_BELOW(true, false, true, false, false, new int[0]),
    NEED_SOLID_BELOW(true, false, true, false, true, new int[0]),
    MAX_ONE_AND_SOLID_BELOW(true, true, true, false, true, new int[0]),
    LEVER(true, true, false, true, false, new int[0]),
    RAILS(true, true, true, false, true, new int[0]),
    POWEREDRAILS(true, true, true, false, true, new int[0]),
    WARTS(true, true, true, false, true, Block.field_72013_bc.field_71990_ca),
    CROPS(true, true, true, false, false, Block.field_72050_aA.field_71990_ca),
    PLANTS(true, true, true, false, true, Block.field_71979_v.field_71990_ca, Block.field_71980_u.field_71990_ca),
    SHROOMS(true, true, true, true, true, Block.field_71979_v.field_71990_ca, Block.field_71981_t.field_71990_ca, Block.field_71994_by.field_71990_ca);

    private boolean placeable;
    private boolean maxOne = false;
    private boolean needSolidAbove = false;
    private boolean needSolidBelow = false;
    private boolean needBlockBelow = false;
    private int[] needBelow = null;

    private BlockRestrictions(boolean placeable) {
        this.placeable = placeable;
    }

    private BlockRestrictions(boolean place, boolean max, boolean blockBelow, boolean above, boolean below, int ... blocks) {
        this(place);
        this.maxOne = max;
        this.needBlockBelow = blockBelow;
        this.needSolidAbove = above;
        this.needSolidBelow = below;
        this.needBelow = blocks;
    }

    public boolean canPlace(int i, ArrayList<FlatLayerInfo> list) {
        int below;
        int meta;
        if (i < 0 || i >= list.size()) {
            return false;
        }
        if (!this.placeable) {
            return false;
        }
        if (this == LEVER) {
            meta = list.get(i).func_82658_c();
            if ((meta & 7) > 0 && (meta & 7) < 5) {
                return false;
            }
            if ((meta & 7) == 5 || (meta & 7) == 6) {
                this.needSolidBelow = true;
                this.needSolidAbove = !true;
            } else {
                this.needSolidBelow = false;
                this.needSolidAbove = !false;
            }
        } else if (this == POWEREDRAILS ? (meta = list.get(i).func_82658_c() % 8) >= 2 && meta <= 5 : this == RAILS && (meta = list.get(i).func_82658_c()) >= 2 && meta <= 5) {
            return false;
        }
        if (this.maxOne) {
            if (list.get(i).func_82657_a() > 1) {
                return false;
            }
            if (list.size() > 1 && i > 0 && list.get(i - 1).func_82659_b() == list.get(i).func_82659_b()) {
                return false;
            }
            if (list.size() > 1 && i < list.size() - 1 && list.get(i + 1).func_82659_b() == list.get(i).func_82659_b()) {
                return false;
            }
        }
        if (this.needBlockBelow) {
            if (i == 0) {
                return false;
            }
            below = list.get(i - 1).func_82659_b();
            if (below == 0) {
                return false;
            }
        }
        if (this.needSolidAbove) {
            if (i == list.size() - 1) {
                return false;
            }
            int above = list.get(i + 1).func_82659_b();
            if (above == 0) {
                return false;
            }
            if (!Block.field_71973_m[above].isBlockNormalCube(null, 0, 0, 0)) {
                return false;
            }
        }
        if (this.needSolidBelow) {
            if (i == 0) {
                return false;
            }
            below = list.get(i - 1).func_82659_b();
            if (below == 0) {
                return false;
            }
            if (!Block.field_71973_m[below].isBlockNormalCube(null, 0, 0, 0)) {
                return false;
            }
        }
        if (this.needBelow != null && this.needBelow.length != 0) {
            if (i == 0) {
                return false;
            }
            below = list.get(i - 1).func_82659_b();
            boolean contains = false;
            for (int id : this.needBelow) {
                if (id != below) continue;
                contains = true;
                break;
            }
            if (!contains) {
                return false;
            }
        }
        return true;
    }

    public boolean maxOne() {
        return this.maxOne;
    }
}

