/*
 * Decompiled with CFR 0.152.
 */
package ferd.flatLove.gui;

import ferd.flatLove.gui.GuiFlatEditLayer;
import ferd.flatLove.main.BlockRestrictions;
import ferd.flatLove.main.FlatLoveMod;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiFlatBlockListSlot
extends GuiSlot {
    public int selectedSlot;
    private ArrayList<ItemStack> blocks;
    private final GuiFlatEditLayer editLayerGui;
    private ArrayList<ItemStack> stackList;
    private int hovered;
    private long lastMove;
    private Minecraft field_77233_a;
    private RenderItem renderItem;
    private FontRenderer fontRenderer;
    private boolean setMeta;

    public GuiFlatBlockListSlot(GuiFlatEditLayer par1, Minecraft par2Minecraft, RenderItem par3RenderItem, FontRenderer par4FontRenderer, ArrayList<ItemStack> blocks, boolean pSetMeta) {
        super(par2Minecraft, 0, 0, 0, 0, 24);
        this.field_77233_a = par2Minecraft;
        this.renderItem = par3RenderItem;
        this.fontRenderer = par4FontRenderer;
        this.editLayerGui = par1;
        this.selectedSlot = -1;
        this.blocks = blocks;
        this.setMeta = pSetMeta;
    }

    protected void func_77214_a(int slotID, int pX, int pY, int par4, Tessellator par5Tessellator) {
        if (this.blocks == null) {
            return;
        }
        ItemStack block = this.blocks.get(slotID);
        if (block != null && this.setMeta) {
            block.func_77964_b(this.editLayerGui.getMeta());
        }
        if (block != null && (block.func_77960_j() < 0 || block.func_77960_j() > 15)) {
            block.func_77964_b(0);
        }
        String name = this.editLayerGui.getItemName(block);
        this.drawItemStackAndFrame(pX, pY, block, false);
        int c = 0xFFFFFF;
        if (block != null && FlatLoveMod.unstableBlocks.containsKey(block.field_77993_c)) {
            c = 16764976;
            BlockRestrictions br = FlatLoveMod.unstableBlocks.get(block.field_77993_c);
            if (br == BlockRestrictions.CRASH) {
                c = 0xFF3030;
            } else if (br == BlockRestrictions.LAG) {
                c = 14712856;
            }
        }
        this.fontRenderer.func_78276_b(name, pX + 18 + 5, pY + 3, c);
    }

    private void drawItemStackAndFrame(int pX, int pY, ItemStack par3ItemStack, boolean drawDamage) {
        this.drawFrame(pX + 1, pY + 1);
        GL11.glEnable((int)32826);
        if (par3ItemStack != null) {
            RenderHelper.func_74520_c();
            if (par3ItemStack.func_77960_j() < 0 || par3ItemStack.func_77960_j() > 15) {
                par3ItemStack.func_77964_b(0);
            }
            this.renderItem.func_77015_a(this.fontRenderer, this.field_77233_a.field_71446_o, par3ItemStack, pX + 2, pY + 2);
            if (drawDamage) {
                int x = pX + 19 - this.fontRenderer.func_78256_a(par3ItemStack.func_77960_j() + "");
                int y = pY + 20 - this.fontRenderer.field_78288_b;
                this.editLayerGui.func_73731_b(this.fontRenderer, par3ItemStack.func_77960_j() + "", x, y, 0xFFFFFF);
            }
            RenderHelper.func_74518_a();
        }
        GL11.glDisable((int)32826);
    }

    private void drawFrame(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_77233_a.func_110434_K().func_110577_a(Gui.field_110323_l);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + 18), 0.0, 0.0, 0.140625);
        tessellator.func_78374_a((double)(x + 18), (double)(y + 18), 0.0, 0.140625, 0.140625);
        tessellator.func_78374_a((double)(x + 18), (double)y, 0.0, 0.140625, 0.0);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    protected int func_77217_a() {
        if (this.blocks == null) {
            return 0;
        }
        return this.blocks.size();
    }

    protected void func_77213_a(int par1, boolean par2) {
        if (this.blocks == null) {
            return;
        }
        if (par2) {
            this.editLayerGui.func_73875_a(new GuiButton(0, 0, 0, ""));
        }
        this.selectedSlot = par1;
        this.editLayerGui.setID(this.blocks.get(par1) == null ? 0 : this.blocks.get((int)par1).field_77993_c, true);
        if (!this.setMeta) {
            this.editLayerGui.setMeta(this.blocks.get(par1) == null ? 0 : this.blocks.get(par1).func_77960_j());
        }
    }

    protected boolean func_77218_a(int par1) {
        return par1 == this.selectedSlot;
    }

    protected void func_77221_c() {
    }

    public void func_77211_a(int mX, int mY, float partTicks) {
        super.func_77211_a(mX, mY, partTicks);
        if (!FlatLoveMod.DRAW_TOOLTIP_SUBTYPES) {
            return;
        }
        if (mY < this.field_77231_b || mY > this.field_77232_c) {
            this.hovered = -1;
            this.stackList = null;
            return;
        }
        int id = this.func_77210_c(mX, mY);
        if (id != this.hovered) {
            this.hovered = id;
            if (id < 0 || id >= this.blocks.size()) {
                return;
            }
            this.stackList = this.editLayerGui.getSubItemList(this.blocks.get(id));
            this.lastMove = System.currentTimeMillis();
        } else if (this.lastMove > 0L && System.currentTimeMillis() - this.lastMove > 1000L && this.hovered > 0 && this.stackList != null && this.stackList.size() > 0) {
            int x = Math.min(mX + 5, this.editLayerGui.field_73880_f - 6 - Math.min(8, this.stackList.size()) * 18);
            int y = Math.min(mY + 5, this.field_77232_c - 19 - this.stackList.size() / 9 * 18);
            for (int i = 0; i < this.stackList.size(); ++i) {
                this.drawItemStackAndFrame(x + i % 8 * 18, y + i / 8 * 18, this.stackList.get(i), true);
            }
        }
    }

    protected int func_77225_g() {
        return this.editLayerGui.field_73880_f - 5;
    }

    public void setSelectedBlock(int id) {
        this.setSelectedBlock(id, -1);
    }

    public void setSelectedBlock(int id, int meta) {
        if (this.blocks == null) {
            return;
        }
        this.func_77208_b(this.blocks.size() * -24);
        if (id <= 0) {
            this.selectedSlot = 0;
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i) == null || this.blocks.get((int)i).field_77993_c != id || meta != -1 && !this.setMeta && this.blocks.get(i).func_77960_j() != meta) continue;
            this.selectedSlot = i;
            this.func_77208_b((i - 2) * 24);
            break;
        }
        if (this.setMeta && meta != 0) {
            this.editLayerGui.setMeta(meta);
        }
    }

    public int getSelectedBlockID() {
        if (this.blocks == null || this.blocks.size() == 0) {
            return 0;
        }
        if (this.selectedSlot < 0) {
            this.selectedSlot = 0;
        }
        if (this.selectedSlot >= this.blocks.size()) {
            this.selectedSlot = this.blocks.size() - 1;
        }
        return this.blocks.get(this.selectedSlot) == null ? 0 : this.blocks.get((int)this.selectedSlot).field_77993_c;
    }

    public int getSelectedBlockMeta() {
        if (this.blocks == null || this.blocks.size() == 0) {
            return 0;
        }
        if (this.selectedSlot < 0) {
            this.selectedSlot = 0;
        }
        if (this.selectedSlot >= this.blocks.size()) {
            this.selectedSlot = this.blocks.size() - 1;
        }
        return this.blocks.get(this.selectedSlot) == null ? 0 : this.blocks.get(this.selectedSlot).func_77960_j();
    }

    public boolean isInList(int id, int meta) {
        if (id < 0 || !this.blocks.contains(id)) {
            return false;
        }
        boolean inList = false;
        for (ItemStack is : this.blocks) {
            if (is.field_77993_c != id || is.func_77960_j() != meta) continue;
            inList = true;
            break;
        }
        return inList;
    }

    protected void func_130003_c() {
    }
}

