/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.TLongCollection;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TLongHash;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;

public class TLongHashSet
extends TLongHash
implements TLongSet,
Externalizable {
    static final long serialVersionUID = 1L;

    public TLongHashSet() {
    }

    public TLongHashSet(int n) {
        super(n);
    }

    public TLongHashSet(int n, float f) {
        super(n, f);
    }

    public TLongHashSet(int n, float f, long l) {
        super(n, f, l);
        if (l != 0L) {
            Arrays.fill(this._set, l);
        }
    }

    public TLongHashSet(Collection<? extends Long> collection) {
        this(Math.max(collection.size(), 10));
        this.addAll(collection);
    }

    public TLongHashSet(TLongCollection tLongCollection) {
        this(Math.max(tLongCollection.size(), 10));
        if (tLongCollection instanceof TLongHashSet) {
            TLongHashSet tLongHashSet = (TLongHashSet)tLongCollection;
            this._loadFactor = tLongHashSet._loadFactor;
            this.no_entry_value = tLongHashSet.no_entry_value;
            if (this.no_entry_value != 0L) {
                Arrays.fill(this._set, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.addAll(tLongCollection);
    }

    public TLongHashSet(long[] lArray) {
        this(Math.max(lArray.length, 10));
        this.addAll(lArray);
    }

    @Override
    public TLongIterator iterator() {
        return new TLongHashIterator(this);
    }

    @Override
    public long[] toArray() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    @Override
    public long[] toArray(long[] lArray) {
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        if (lArray.length > this._size) {
            lArray[this._size] = this.no_entry_value;
        }
        return lArray;
    }

    @Override
    public boolean add(long l) {
        int n = this.insertKey(l);
        if (n < 0) {
            return false;
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    @Override
    public boolean remove(long l) {
        int n = this.index(l);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (obj instanceof Long) {
                long l = (Long)obj;
                if (this.contains(l)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TLongCollection tLongCollection) {
        TLongIterator tLongIterator = tLongCollection.iterator();
        while (tLongIterator.hasNext()) {
            long l = tLongIterator.next();
            if (this.contains(l)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(long[] lArray) {
        int n = lArray.length;
        while (n-- > 0) {
            if (this.contains(lArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        boolean bl = false;
        for (Long l : collection) {
            long l2 = l;
            if (!this.add(l2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(TLongCollection tLongCollection) {
        boolean bl = false;
        TLongIterator tLongIterator = tLongCollection.iterator();
        while (tLongIterator.hasNext()) {
            long l = tLongIterator.next();
            if (!this.add(l)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(long[] lArray) {
        boolean bl = false;
        int n = lArray.length;
        while (n-- > 0) {
            if (!this.add(lArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        TLongIterator tLongIterator = this.iterator();
        while (tLongIterator.hasNext()) {
            if (collection.contains(tLongIterator.next())) continue;
            tLongIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(TLongCollection tLongCollection) {
        if (this == tLongCollection) {
            return false;
        }
        boolean bl = false;
        TLongIterator tLongIterator = this.iterator();
        while (tLongIterator.hasNext()) {
            if (tLongCollection.contains(tLongIterator.next())) continue;
            tLongIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(long[] lArray) {
        boolean bl = false;
        Arrays.sort(lArray);
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        this._autoCompactTemporaryDisable = true;
        int n = lArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(lArray, lArray2[n]) >= 0) continue;
            this.removeAt(n);
            bl = true;
        }
        this._autoCompactTemporaryDisable = false;
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            long l;
            if (!(obj instanceof Long) || !this.remove(l = ((Long)obj).longValue())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(TLongCollection tLongCollection) {
        boolean bl = false;
        TLongIterator tLongIterator = tLongCollection.iterator();
        while (tLongIterator.hasNext()) {
            long l = tLongIterator.next();
            if (!this.remove(l)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(long[] lArray) {
        boolean bl = false;
        int n = lArray.length;
        while (n-- > 0) {
            if (!this.remove(lArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        super.clear();
        long[] lArray = this._set;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = this.no_entry_value;
            byArray[n] = 0;
        }
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertKey(l);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TLongSet)) {
            return false;
        }
        TLongSet tLongSet = (TLongSet)object;
        if (tLongSet.size() != this.size()) {
            return false;
        }
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1 || tLongSet.contains(this._set[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = this._states.length;
        while (n2-- > 0) {
            if (this._states[n2] != 1) continue;
            n += HashFunctions.hash(this._set[n2]);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._size * 2 + 2);
        stringBuilder.append("{");
        int n = this._states.length;
        int n2 = 1;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            stringBuilder.append(this._set[n]);
            if (n2++ >= this._size) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this._size);
        objectOutput.writeFloat(this._loadFactor);
        objectOutput.writeLong(this.no_entry_value);
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            objectOutput.writeLong(this._set[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        if (by >= 1) {
            this._loadFactor = objectInput.readFloat();
            this.no_entry_value = objectInput.readLong();
            if (this.no_entry_value != 0L) {
                Arrays.fill(this._set, this.no_entry_value);
            }
        }
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInput.readLong();
            this.add(l);
        }
    }

    class TLongHashIterator
    extends THashPrimitiveIterator
    implements TLongIterator {
        private final TLongHash _hash;

        public TLongHashIterator(TLongHash tLongHash) {
            super(tLongHash);
            this._hash = tLongHash;
        }

        @Override
        public long next() {
            this.moveToNextIndex();
            return this._hash._set[this._index];
        }
    }
}

