/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class TLinkedHashSet<E>
extends THashSet<E> {
    TIntList order;

    public TLinkedHashSet() {
    }

    public TLinkedHashSet(int n) {
        super(n);
    }

    public TLinkedHashSet(int n, float f) {
        super(n, f);
    }

    public TLinkedHashSet(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public int setUp(int n) {
        this.order = new TIntArrayList(n){

            @Override
            public void ensureCapacity(int n) {
                if (n > this._data.length) {
                    int n2 = Math.max(TLinkedHashSet.this._set.length, n);
                    int[] nArray = new int[n2];
                    System.arraycopy(this._data, 0, nArray, 0, this._data.length);
                    this._data = nArray;
                }
            }
        };
        return super.setUp(n);
    }

    @Override
    public void clear() {
        super.clear();
        this.order.clear();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean bl = true;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean add(E e) {
        int n = this.insertKey(e);
        if (n < 0) {
            return false;
        }
        if (!this.order.add(n)) {
            throw new IllegalStateException("Order not changed after insert");
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    @Override
    protected void removeAt(int n) {
        this.order.remove(n);
        super.removeAt(n);
    }

    @Override
    protected void rehash(int n) {
        TIntLinkedList tIntLinkedList = new TIntLinkedList(this.order);
        int n2 = this.size();
        Object[] objectArray = this._set;
        this.order.clear();
        this._set = new Object[n];
        Arrays.fill(this._set, FREE);
        TIntIterator tIntIterator = tIntLinkedList.iterator();
        while (tIntIterator.hasNext()) {
            int n3 = tIntIterator.next();
            Object object = objectArray[n3];
            if (object == FREE || object == REMOVED) {
                throw new IllegalStateException("Iterating over empty location while rehashing");
            }
            if (object == FREE || object == REMOVED) continue;
            int n4 = this.insertKey(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object, this.size(), n2, objectArray);
            }
            if (this.order.add(n4)) continue;
            throw new IllegalStateException("Order not changed after insert");
        }
    }

    @Override
    protected void writeEntries(ObjectOutput objectOutput) throws IOException {
        WriteProcedure writeProcedure = new WriteProcedure(objectOutput);
        if (!this.order.forEach(writeProcedure)) {
            throw writeProcedure.getIoException();
        }
    }

    @Override
    public TObjectHashIterator<E> iterator() {
        return new TObjectHashIterator<E>(this){
            TIntIterator localIterator;
            int lastIndex;
            {
                this.localIterator = TLinkedHashSet.this.order.iterator();
            }

            @Override
            public E next() {
                this.lastIndex = this.localIterator.next();
                return this.objectAtIndex(this.lastIndex);
            }

            @Override
            public boolean hasNext() {
                return this.localIterator.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                this.localIterator.remove();
                try {
                    this._hash.tempDisableAutoCompaction();
                    TLinkedHashSet.this.removeAt(this.lastIndex);
                }
                finally {
                    this._hash.reenableAutoCompaction(false);
                }
            }
        };
    }

    @Override
    public boolean forEach(TObjectProcedure<? super E> tObjectProcedure) {
        ForEachProcedure forEachProcedure = new ForEachProcedure(this._set, tObjectProcedure);
        return this.order.forEach(forEachProcedure);
    }

    class ForEachProcedure
    implements TIntProcedure {
        boolean changed = false;
        final Object[] set;
        final TObjectProcedure<? super E> procedure;

        public ForEachProcedure(Object[] objectArray, TObjectProcedure<? super E> tObjectProcedure) {
            this.set = objectArray;
            this.procedure = tObjectProcedure;
        }

        @Override
        public boolean execute(int n) {
            return this.procedure.execute(this.set[n]);
        }
    }

    class WriteProcedure
    implements TIntProcedure {
        final ObjectOutput output;
        IOException ioException;

        WriteProcedure(ObjectOutput objectOutput) {
            this.output = objectOutput;
        }

        public IOException getIoException() {
            return this.ioException;
        }

        @Override
        public boolean execute(int n) {
            try {
                this.output.writeObject(TLinkedHashSet.this._set[n]);
            }
            catch (IOException iOException) {
                this.ioException = iOException;
                return false;
            }
            return true;
        }
    }
}

