/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TCustomObjectHash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.strategy.HashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCustomHashMap<K, V>
extends TCustomObjectHash<K>
implements TMap<K, V>,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient V[] _values;

    public TCustomHashMap() {
    }

    public TCustomHashMap(HashingStrategy<? super K> hashingStrategy) {
        super(hashingStrategy);
    }

    public TCustomHashMap(HashingStrategy<? super K> hashingStrategy, int n) {
        super(hashingStrategy, n);
    }

    public TCustomHashMap(HashingStrategy<? super K> hashingStrategy, int n, float f) {
        super(hashingStrategy, n, f);
    }

    public TCustomHashMap(HashingStrategy<? super K> hashingStrategy, Map<? extends K, ? extends V> map) {
        this((HashingStrategy<K>)hashingStrategy, map.size());
        this.putAll(map);
    }

    public TCustomHashMap(HashingStrategy<? super K> hashingStrategy, TCustomHashMap<? extends K, ? extends V> tCustomHashMap) {
        this((HashingStrategy<K>)hashingStrategy, tCustomHashMap.size());
        this.putAll(tCustomHashMap);
    }

    @Override
    public int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    @Override
    public V put(K k, V v) {
        int n = this.insertKey(k);
        return this.doPut(v, n);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        int n = this.insertKey(k);
        if (n < 0) {
            return this._values[-n - 1];
        }
        return this.doPut(v, n);
    }

    private V doPut(V v, int n) {
        V v2 = null;
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            v2 = this._values[n];
            bl = false;
        }
        this._values[n] = v;
        if (bl) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return v2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(map));
    }

    @Override
    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TObjectObjectProcedure<K, V>(){
            private boolean first = true;

            @Override
            public boolean execute(K k, V v) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(k);
                stringBuilder.append("=");
                stringBuilder.append(v);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean forEachKey(TObjectProcedure<? super K> tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure<? super V> tObjectProcedure) {
        V[] VArray = this._values;
        Object[] objectArray = this._set;
        int n = VArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectProcedure.execute(VArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectObjectProcedure<? super K, ? super V> tObjectObjectProcedure) {
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], VArray[n])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TObjectObjectProcedure<? super K, ? super V> tObjectObjectProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], VArray[n])) continue;
                this.removeAt(n);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction<V, V> tObjectFunction) {
        V[] VArray = this._values;
        Object[] objectArray = this._set;
        int n = VArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED) continue;
            VArray[n] = tObjectFunction.execute(VArray[n]);
        }
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int n3 = this.size();
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        this._set = new Object[n];
        Arrays.fill(this._set, FREE);
        this._values = new Object[n];
        int n4 = n2;
        while (n4-- > 0) {
            Object object = objectArray[n4];
            if (object == FREE || object == REMOVED) continue;
            int n5 = this.insertKey(object);
            if (n5 < 0) {
                this.throwObjectContractViolation(this._set[-n5 - 1], object, this.size(), n3, objectArray);
            }
            this._values[n5] = VArray[n4];
        }
    }

    @Override
    public V get(Object object) {
        int n = this.index(object);
        if (n < 0 || !this.strategy.equals(this._set[n], object)) {
            return null;
        }
        return this._values[n];
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public V remove(Object object) {
        V v = null;
        int n = this.index(object);
        if (n >= 0) {
            v = this._values[n];
            this.removeAt(n);
        }
        return v;
    }

    @Override
    public void removeAt(int n) {
        this._values[n] = null;
        super.removeAt(n);
    }

    @Override
    public Collection<V> values() {
        return new ValueView();
    }

    @Override
    public Set<K> keySet() {
        return new KeyView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        if (null == object) {
            int n = VArray.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != VArray[n]) continue;
                return true;
            }
        } else {
            int n = VArray.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != VArray[n] && !this.strategy.equals(object, VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this._size);
        int n = this._set.length;
        while (n-- > 0) {
            if (this._set[n] == REMOVED || this._set[n] == FREE) continue;
            objectOutput.writeObject(this._set[n]);
            objectOutput.writeObject(this._values[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 0) {
            super.readExternal(objectInput);
        }
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
        }
    }

    final class Entry
    implements Map.Entry<K, V> {
        private K key;
        private V val;
        private final int index;

        Entry(K k, V v, int n) {
            this.key = k;
            this.val = v;
            this.index = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V v) {
            if (TCustomHashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            Object v2 = this.val;
            TCustomHashMap.this._values[this.index] = v;
            this.val = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = this;
                Map.Entry entry2 = (Map.Entry)object;
                return (entry.getKey() == null ? entry2.getKey() == null : TCustomHashMap.this.strategy.equals(entry.getKey(), entry2.getKey())) && (entry.getValue() == null ? entry2.getValue() == null : entry.getValue().equals(entry2.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.key + "=" + this.val;
        }
    }

    protected class KeyView
    extends MapBackedView<K> {
        protected KeyView() {
        }

        @Override
        public Iterator<K> iterator() {
            return new TObjectHashIterator(TCustomHashMap.this);
        }

        @Override
        public boolean removeElement(K k) {
            return null != TCustomHashMap.this.remove(k);
        }

        @Override
        public boolean containsElement(K k) {
            return TCustomHashMap.this.contains(k);
        }
    }

    private abstract class MapBackedView<E>
    extends AbstractSet<E>
    implements Set<E>,
    Iterable<E> {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object object) {
            return this.containsElement(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.removeElement(object);
        }

        @Override
        public void clear() {
            TCustomHashMap.this.clear();
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TCustomHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator<E> iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator<E> iterator = this.iterator();
            T[] TArray = objectArray;
            for (int i = 0; i < n; ++i) {
                TArray[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean isEmpty() {
            return TCustomHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public String toString() {
            Iterator<E> iterator = this.iterator();
            if (!iterator.hasNext()) {
                return "{}";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            while (true) {
                E e;
                stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
                if (!iterator.hasNext()) {
                    return stringBuilder.append('}').toString();
                }
                stringBuilder.append(", ");
            }
        }
    }

    protected class EntryView
    extends MapBackedView<Map.Entry<K, V>> {
        protected EntryView() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(TCustomHashMap.this);
        }

        @Override
        public boolean removeElement(Map.Entry<K, V> entry) {
            Object v;
            Object k = this.keyForEntry(entry);
            int n = TCustomHashMap.this.index(k);
            if (n >= 0 && ((v = this.valueForEntry(entry)) == TCustomHashMap.this._values[n] || null != v && TCustomHashMap.this.strategy.equals(v, TCustomHashMap.this._values[n]))) {
                TCustomHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsElement(Map.Entry<K, V> entry) {
            Object v = TCustomHashMap.this.get(this.keyForEntry(entry));
            Object v2 = entry.getValue();
            return v2 == v || null != v && TCustomHashMap.this.strategy.equals(v, v2);
        }

        protected V valueForEntry(Map.Entry<K, V> entry) {
            return entry.getValue();
        }

        protected K keyForEntry(Map.Entry<K, V> entry) {
            return entry.getKey();
        }

        private final class EntryIterator
        extends TObjectHashIterator {
            EntryIterator(TCustomHashMap<K, V> tCustomHashMap) {
                super(tCustomHashMap);
            }

            @Override
            public Entry objectAtIndex(int n) {
                return new Entry(TCustomHashMap.this._set[n], TCustomHashMap.this._values[n], n);
            }
        }
    }

    protected class ValueView
    extends MapBackedView<V> {
        protected ValueView() {
        }

        @Override
        public Iterator<V> iterator() {
            return new TObjectHashIterator(TCustomHashMap.this){

                @Override
                protected V objectAtIndex(int n) {
                    return TCustomHashMap.this._values[n];
                }
            };
        }

        @Override
        public boolean containsElement(V v) {
            return TCustomHashMap.this.containsValue(v);
        }

        @Override
        public boolean removeElement(V v) {
            V[] VArray = TCustomHashMap.this._values;
            Object[] objectArray = TCustomHashMap.this._set;
            int n = VArray.length;
            while (n-- > 0) {
                if ((objectArray[n] == TObjectHash.FREE || objectArray[n] == TObjectHash.REMOVED || v != VArray[n]) && (null == VArray[n] || !TCustomHashMap.this.strategy.equals(VArray[n], v))) continue;
                TCustomHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }
    }

    private static final class EqProcedure<K, V>
    implements TObjectObjectProcedure<K, V> {
        private final Map<K, V> _otherMap;

        EqProcedure(Map<K, V> map) {
            this._otherMap = map;
        }

        @Override
        public final boolean execute(K k, V v) {
            if (v == null && !this._otherMap.containsKey(k)) {
                return false;
            }
            V v2 = this._otherMap.get(k);
            return v2 == v || v2 != null && v2.equals(v);
        }
    }

    private final class HashProcedure
    implements TObjectObjectProcedure<K, V> {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(K k, V v) {
            this.h += HashFunctions.hash(k) ^ (v == null ? 0 : v.hashCode());
            return true;
        }
    }
}

