/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.procedure.TIntProcedure;
import java.util.Arrays;

public abstract class TIntHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient int[] _set;
    protected int no_entry_value;
    protected boolean consumeFreeSlot;

    public TIntHash() {
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TIntHash(int n) {
        super(n);
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TIntHash(int n, float f) {
        super(n, f);
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TIntHash(int n, float f, int n2) {
        super(n, f);
        this.no_entry_value = n2;
        if (n2 != 0) {
            Arrays.fill(this._set, n2);
        }
    }

    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new int[n2];
        return n2;
    }

    public boolean contains(int n) {
        return this.index(n) >= 0;
    }

    public boolean forEach(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int n) {
        this._set[n] = this.no_entry_value;
        super.removeAt(n);
    }

    protected int index(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        byte by = byArray[n4];
        if (by == 0) {
            return -1;
        }
        if (by == 1 && nArray[n4] == n) {
            return n4;
        }
        return this.indexRehashed(n, n4, n3, by);
    }

    int indexRehashed(int n, int n2, int n3, byte by) {
        int n4 = this._set.length;
        int n5 = 1 + n3 % (n4 - 2);
        int n6 = n2;
        do {
            if ((n2 -= n5) < 0) {
                n2 += n4;
            }
            if ((by = this._states[n2]) == 0) {
                return -1;
            }
            if (n != this._set[n2] || by == 2) continue;
            return n2;
        } while (n2 != n6);
        return -1;
    }

    protected int insertKey(int n) {
        int n2 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n3 = n2 % this._states.length;
        byte by = this._states[n3];
        this.consumeFreeSlot = false;
        if (by == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(n3, n);
            return n3;
        }
        if (by == 1 && this._set[n3] == n) {
            return -n3 - 1;
        }
        return this.insertKeyRehash(n, n3, n2, by);
    }

    int insertKeyRehash(int n, int n2, int n3, byte by) {
        int n4 = this._set.length;
        int n5 = 1 + n3 % (n4 - 2);
        int n6 = n2;
        int n7 = -1;
        do {
            if (by == 2 && n7 == -1) {
                n7 = n2;
            }
            if ((n2 -= n5) < 0) {
                n2 += n4;
            }
            if ((by = this._states[n2]) == 0) {
                if (n7 != -1) {
                    this.insertKeyAt(n7, n);
                    return n7;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(n2, n);
                return n2;
            }
            if (by != 1 || this._set[n2] != n) continue;
            return -n2 - 1;
        } while (n2 != n6);
        if (n7 != -1) {
            this.insertKeyAt(n7, n);
            return n7;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int n, int n2) {
        this._set[n] = n2;
        this._states[n] = 1;
    }
}

