/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TIntCollection;
import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TIntHash;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TIntObjectHashMap<V>
extends TIntHash
implements TIntObjectMap<V>,
Externalizable {
    static final long serialVersionUID = 1L;
    private final TIntObjectProcedure<V> PUT_ALL_PROC = new TIntObjectProcedure<V>(){

        @Override
        public boolean execute(int n, V v) {
            TIntObjectHashMap.this.put(n, v);
            return true;
        }
    };
    protected transient V[] _values;
    protected int no_entry_key;

    public TIntObjectHashMap() {
    }

    public TIntObjectHashMap(int n) {
        super(n);
        this.no_entry_key = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    public TIntObjectHashMap(int n, float f) {
        super(n, f);
        this.no_entry_key = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    public TIntObjectHashMap(int n, float f, int n2) {
        super(n, f);
        this.no_entry_key = n2;
    }

    public TIntObjectHashMap(TIntObjectMap<? extends V> tIntObjectMap) {
        this(tIntObjectMap.size(), 0.5f, tIntObjectMap.getNoEntryKey());
        this.putAll(tIntObjectMap);
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        V[] VArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertKey(n4);
            this._values[n5] = VArray[n3];
        }
    }

    @Override
    public int getNoEntryKey() {
        return this.no_entry_key;
    }

    @Override
    public boolean containsKey(int n) {
        return this.contains(n);
    }

    @Override
    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        V[] VArray = this._values;
        if (null == object) {
            int n = VArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || null != VArray[n]) continue;
                return true;
            }
        } else {
            int n = VArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != VArray[n] && !object.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? null : (V)this._values[n2];
    }

    @Override
    public V put(int n, V v) {
        int n2 = this.insertKey(n);
        return this.doPut(v, n2);
    }

    @Override
    public V putIfAbsent(int n, V v) {
        int n2 = this.insertKey(n);
        if (n2 < 0) {
            return this._values[-n2 - 1];
        }
        return this.doPut(v, n2);
    }

    private V doPut(V v, int n) {
        V v2 = null;
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            v2 = this._values[n];
            bl = false;
        }
        this._values[n] = v;
        if (bl) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return v2;
    }

    @Override
    public V remove(int n) {
        V v = null;
        int n2 = this.index(n);
        if (n2 >= 0) {
            v = this._values[n2];
            this.removeAt(n2);
        }
        return v;
    }

    @Override
    protected void removeAt(int n) {
        this._values[n] = null;
        super.removeAt(n);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        Set<Map.Entry<Integer, V>> set = map.entrySet();
        for (Map.Entry<Integer, V> entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TIntObjectMap<? extends V> tIntObjectMap) {
        tIntObjectMap.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public TIntSet keySet() {
        return new KeyView();
    }

    @Override
    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    @Override
    public int[] keys(int[] nArray) {
        if (nArray.length < this._size) {
            nArray = new int[this._size];
        }
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    @Override
    public Collection<V> valueCollection() {
        return new ValueView();
    }

    @Override
    public Object[] values() {
        Object[] objectArray = new Object[this.size()];
        V[] VArray = this._values;
        byte[] byArray = this._states;
        int n = VArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = VArray[n];
        }
        return objectArray;
    }

    @Override
    public V[] values(V[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        V[] VArray = this._values;
        byte[] byArray = this._states;
        int n = VArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = VArray[n];
        }
        return objectArray;
    }

    @Override
    public TIntObjectIterator<V> iterator() {
        return new TIntObjectHashIterator(this);
    }

    @Override
    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure<? super V> tObjectProcedure) {
        byte[] byArray = this._states;
        V[] VArray = this._values;
        int n = VArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(VArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TIntObjectProcedure<? super V> tIntObjectProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        V[] VArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], VArray[n])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TIntObjectProcedure<? super V> tIntObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        V[] VArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n = nArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], VArray[n])) continue;
                this.removeAt(n);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction<V, V> tObjectFunction) {
        byte[] byArray = this._states;
        V[] VArray = this._values;
        int n = VArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            VArray[n] = tObjectFunction.execute(VArray[n]);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TIntObjectMap)) {
            return false;
        }
        TIntObjectMap tIntObjectMap = (TIntObjectMap)object;
        if (tIntObjectMap.size() != this.size()) {
            return false;
        }
        try {
            TIntObjectIterator<V> tIntObjectIterator = this.iterator();
            while (tIntObjectIterator.hasNext()) {
                tIntObjectIterator.advance();
                int n = tIntObjectIterator.key();
                V v = tIntObjectIterator.value();
                if (!(v == null ? tIntObjectMap.get(n) != null || !tIntObjectMap.containsKey(n) : !v.equals(tIntObjectMap.get(n)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        V[] VArray = this._values;
        byte[] byArray = this._states;
        int n2 = VArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            n += HashFunctions.hash(this._set[n2]) ^ (VArray[n2] == null ? 0 : VArray[n2].hashCode());
        }
        return n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.no_entry_key);
        objectOutput.writeInt(this._size);
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            objectOutput.writeInt(this._set[n]);
            objectOutput.writeObject(this._values[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        super.readExternal(objectInput);
        this.no_entry_key = objectInput.readInt();
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInput.readInt();
            Object object = objectInput.readObject();
            this.put(n2, object);
        }
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TIntObjectProcedure<V>(){
            private boolean first = true;

            @Override
            public boolean execute(int n, Object object) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(n);
                stringBuilder.append("=");
                stringBuilder.append(object);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    class TIntObjectHashIterator<V>
    extends THashPrimitiveIterator
    implements TIntObjectIterator<V> {
        private final TIntObjectHashMap<V> _map;

        public TIntObjectHashIterator(TIntObjectHashMap<V> tIntObjectHashMap2) {
            super(tIntObjectHashMap2);
            this._map = tIntObjectHashMap2;
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public int key() {
            return this._map._set[this._index];
        }

        @Override
        public V value() {
            return this._map._values[this._index];
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value();
            this._map._values[this._index] = v;
            return v2;
        }
    }

    private abstract class MapBackedView<E>
    extends AbstractSet<E>
    implements Set<E>,
    Iterable<E> {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object object) {
            return this.containsElement(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.removeElement(object);
        }

        @Override
        public void clear() {
            TIntObjectHashMap.this.clear();
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TIntObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator<E> iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator<E> iterator = this.iterator();
            T[] TArray = objectArray;
            for (int i = 0; i < n; ++i) {
                TArray[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public boolean isEmpty() {
            return TIntObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }

    protected class ValueView
    extends MapBackedView<V> {
        protected ValueView() {
        }

        @Override
        public Iterator<V> iterator() {
            return new TIntObjectValueHashIterator(TIntObjectHashMap.this){

                @Override
                protected V objectAtIndex(int n) {
                    return TIntObjectHashMap.this._values[n];
                }
            };
        }

        @Override
        public boolean containsElement(V v) {
            return TIntObjectHashMap.this.containsValue(v);
        }

        @Override
        public boolean removeElement(V v) {
            V[] VArray = TIntObjectHashMap.this._values;
            byte[] byArray = TIntObjectHashMap.this._states;
            int n = VArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || v != VArray[n] && (null == VArray[n] || !VArray[n].equals(v))) continue;
                TIntObjectHashMap.this.removeAt(n);
                return true;
            }
            return false;
        }

        class TIntObjectValueHashIterator
        extends THashPrimitiveIterator
        implements Iterator<V> {
            protected final TIntObjectHashMap _map;

            public TIntObjectValueHashIterator(TIntObjectHashMap tIntObjectHashMap) {
                super(tIntObjectHashMap);
                this._map = tIntObjectHashMap;
            }

            protected V objectAtIndex(int n) {
                byte[] byArray = TIntObjectHashMap.this._states;
                Object v = this._map._values[n];
                if (byArray[n] != 1) {
                    return null;
                }
                return v;
            }

            @Override
            public V next() {
                this.moveToNextIndex();
                return this._map._values[this._index];
            }
        }
    }

    class KeyView
    implements TIntSet {
        KeyView() {
        }

        @Override
        public int getNoEntryValue() {
            return TIntObjectHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TIntObjectHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return TIntObjectHashMap.this._size == 0;
        }

        @Override
        public boolean contains(int n) {
            return TIntObjectHashMap.this.containsKey(n);
        }

        @Override
        public TIntIterator iterator() {
            return new TIntHashIterator(TIntObjectHashMap.this);
        }

        @Override
        public int[] toArray() {
            return TIntObjectHashMap.this.keys();
        }

        @Override
        public int[] toArray(int[] nArray) {
            return TIntObjectHashMap.this.keys(nArray);
        }

        @Override
        public boolean add(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int n) {
            return null != TIntObjectHashMap.this.remove(n);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (TIntObjectHashMap.this.containsKey((Integer)obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection tIntCollection) {
            if (tIntCollection == this) {
                return true;
            }
            TIntIterator tIntIterator = tIntCollection.iterator();
            while (tIntIterator.hasNext()) {
                if (TIntObjectHashMap.this.containsKey(tIntIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] nArray) {
            for (int n : nArray) {
                if (TIntObjectHashMap.this.containsKey(n)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection tIntCollection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] nArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (collection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(TIntCollection tIntCollection) {
            if (this == tIntCollection) {
                return false;
            }
            boolean bl = false;
            TIntIterator tIntIterator = this.iterator();
            while (tIntIterator.hasNext()) {
                if (tIntCollection.contains(tIntIterator.next())) continue;
                tIntIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(int[] nArray) {
            boolean bl = false;
            Arrays.sort(nArray);
            int[] nArray2 = TIntObjectHashMap.this._set;
            byte[] byArray = TIntObjectHashMap.this._states;
            int n = nArray2.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || Arrays.binarySearch(nArray, nArray2[n]) >= 0) continue;
                TIntObjectHashMap.this.removeAt(n);
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                int n;
                if (!(obj instanceof Integer) || !this.remove(n = ((Integer)obj).intValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(TIntCollection tIntCollection) {
            if (tIntCollection == this) {
                this.clear();
                return true;
            }
            boolean bl = false;
            TIntIterator tIntIterator = tIntCollection.iterator();
            while (tIntIterator.hasNext()) {
                int n = tIntIterator.next();
                if (!this.remove(n)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(int[] nArray) {
            boolean bl = false;
            int n = nArray.length;
            while (n-- > 0) {
                if (!this.remove(nArray[n])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            TIntObjectHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure tIntProcedure) {
            return TIntObjectHashMap.this.forEachKey(tIntProcedure);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof TIntSet)) {
                return false;
            }
            TIntSet tIntSet = (TIntSet)object;
            if (tIntSet.size() != this.size()) {
                return false;
            }
            int n = TIntObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TIntObjectHashMap.this._states[n] != 1 || tIntSet.contains(TIntObjectHashMap.this._set[n])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n = 0;
            int n2 = TIntObjectHashMap.this._states.length;
            while (n2-- > 0) {
                if (TIntObjectHashMap.this._states[n2] != 1) continue;
                n += HashFunctions.hash(TIntObjectHashMap.this._set[n2]);
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            boolean bl = true;
            int n = TIntObjectHashMap.this._states.length;
            while (n-- > 0) {
                if (TIntObjectHashMap.this._states[n] != 1) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(TIntObjectHashMap.this._set[n]);
            }
            return stringBuilder.toString();
        }

        class TIntHashIterator
        extends THashPrimitiveIterator
        implements TIntIterator {
            private final TIntHash _hash;

            public TIntHashIterator(TIntHash tIntHash) {
                super(tIntHash);
                this._hash = tIntHash;
            }

            @Override
            public int next() {
                this.moveToNextIndex();
                return this._hash._set[this._index];
            }
        }
    }
}

