/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;

public abstract class TPrimitiveHash
extends THash {
    static final long serialVersionUID = 1L;
    public transient byte[] _states;
    public static final byte FREE = 0;
    public static final byte FULL = 1;
    public static final byte REMOVED = 2;

    public TPrimitiveHash() {
    }

    public TPrimitiveHash(int n) {
        this(n, 0.5f);
    }

    public TPrimitiveHash(int n, float f) {
        n = Math.max(1, n);
        this._loadFactor = f;
        this.setUp(HashFunctions.fastCeil((float)n / f));
    }

    @Override
    public int capacity() {
        return this._states.length;
    }

    @Override
    protected void removeAt(int n) {
        this._states[n] = 2;
        super.removeAt(n);
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._states = new byte[n2];
        return n2;
    }
}

