/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.strategy.HashingStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class TCustomObjectHash<T>
extends TObjectHash<T> {
    static final long serialVersionUID = 8766048185963756400L;
    protected HashingStrategy<? super T> strategy;

    public TCustomObjectHash() {
    }

    public TCustomObjectHash(HashingStrategy<? super T> hashingStrategy) {
        this.strategy = hashingStrategy;
    }

    public TCustomObjectHash(HashingStrategy<? super T> hashingStrategy, int n) {
        super(n);
        this.strategy = hashingStrategy;
    }

    public TCustomObjectHash(HashingStrategy<? super T> hashingStrategy, int n, float f) {
        super(n, f);
        this.strategy = hashingStrategy;
    }

    @Override
    protected int hash(Object object) {
        return this.strategy.computeHashCode(object);
    }

    @Override
    protected boolean equals(Object object, Object object2) {
        return object2 != REMOVED && this.strategy.equals(object, object2);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.strategy);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        super.readExternal(objectInput);
        this.strategy = (HashingStrategy)objectInput.readObject();
    }
}

