/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl;

public final class HashFunctions {
    public static int hash(double d) {
        assert (!Double.isNaN(d)) : "Values of NaN are not supported.";
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public static int hash(float f) {
        assert (!Float.isNaN(f)) : "Values of NaN are not supported.";
        return Float.floatToIntBits(f * 6.6360896E8f);
    }

    public static int hash(int n) {
        return n;
    }

    public static int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int hash(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int fastCeil(float f) {
        int n = (int)f;
        if (f - (float)n > 0.0f) {
            ++n;
        }
        return n;
    }
}

