/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TCustomObjectHash;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.procedure.array.ToObjectArrayProceedure;
import gnu.trove.strategy.HashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class TCustomHashSet<E>
extends TCustomObjectHash<E>
implements Set<E>,
Iterable<E>,
Externalizable {
    static final long serialVersionUID = 1L;

    public TCustomHashSet() {
    }

    public TCustomHashSet(HashingStrategy<? super E> hashingStrategy) {
        super(hashingStrategy);
    }

    public TCustomHashSet(HashingStrategy<? super E> hashingStrategy, int n) {
        super(hashingStrategy, n);
    }

    public TCustomHashSet(HashingStrategy<? super E> hashingStrategy, int n, float f) {
        super(hashingStrategy, n, f);
    }

    public TCustomHashSet(HashingStrategy<? super E> hashingStrategy, Collection<? extends E> collection) {
        this((HashingStrategy<E>)hashingStrategy, collection.size());
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        int n = this.insertKey(e);
        if (n < 0) {
            return false;
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.size()) {
            return false;
        }
        return this.containsAll(set);
    }

    @Override
    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int n3 = this.size();
        Object[] objectArray = this._set;
        this._set = new Object[n];
        Arrays.fill(this._set, FREE);
        int n4 = n2;
        while (n4-- > 0) {
            int n5;
            Object object = objectArray[n4];
            if (object == FREE || object == REMOVED || (n5 = this.insertKey(object)) >= 0) continue;
            this.throwObjectContractViolation(this._set[-n5 - 1], object, this.size(), n3, objectArray);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.forEach(new ToObjectArrayProceedure<Object>(objectArray));
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.forEach(new ToObjectArrayProceedure<T>(objectArray));
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
    }

    @Override
    public boolean remove(Object object) {
        int n = this.index(object);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    @Override
    public TObjectHashIterator<E> iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        int n = collection.size();
        this.ensureCapacity(n);
        Iterator<E> iterator = collection.iterator();
        while (n-- > 0) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        int n = collection.size();
        Iterator<?> iterator = collection.iterator();
        while (n-- > 0) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        int n = this.size();
        Iterator iterator = this.iterator();
        while (n-- > 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        this.forEach(new TObjectProcedure<E>(){
            private boolean first = true;

            @Override
            public boolean execute(Object object) {
                if (this.first) {
                    this.first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this._size);
        int n = this._set.length;
        while (n-- > 0) {
            if (this._set[n] == REMOVED || this._set[n] == FREE) continue;
            objectOutput.writeObject(this._set[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 0) {
            super.readExternal(objectInput);
        }
        int n = objectInput.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInput.readObject();
            this.add(object);
        }
    }

    private final class HashProcedure
    implements TObjectProcedure<E> {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(E e) {
            this.h += HashFunctions.hash(e);
            return true;
        }
    }
}

