/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.linked;

import gnu.trove.list.TLinkable;
import gnu.trove.procedure.TObjectProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TLinkedList<T extends TLinkable<T>>
extends AbstractSequentialList<T>
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected T _head;
    protected T _tail;
    protected int _size = 0;

    @Override
    public ListIterator<T> listIterator(int n) {
        return new IteratorImpl(n);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void add(int n, T t) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index:" + n);
        }
        this.insert(n, t);
    }

    @Override
    public boolean add(T t) {
        this.insert(this._size, t);
        return true;
    }

    @Override
    public void addFirst(T t) {
        this.insert(0, t);
    }

    @Override
    public void addLast(T t) {
        this.insert(this.size(), t);
    }

    @Override
    public void clear() {
        if (null != this._head) {
            for (Object t = this._head.getNext(); t != null; t = t.getNext()) {
                Object object = t.getPrevious();
                object.setNext(null);
                t.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        for (T t = this._head; t != null; t = t.getNext()) {
            objectArray[n++] = t;
        }
        return objectArray;
    }

    public Object[] toUnlinkedArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        T t = this._head;
        while (t != null) {
            objectArray[n] = t;
            T t2 = t;
            t = t.getNext();
            t2.setNext(null);
            t2.setPrevious(null);
            ++n;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return objectArray;
    }

    public T[] toUnlinkedArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (TLinkable[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        int n2 = 0;
        T t = this._head;
        while (t != null) {
            objectArray[n2] = t;
            T t2 = t;
            t = t.getNext();
            t2.setNext(null);
            t2.setPrevious(null);
            ++n2;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return objectArray;
    }

    @Override
    public boolean contains(Object object) {
        for (T t = this._head; t != null; t = t.getNext()) {
            if (!object.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this._size);
        }
        if (n > this._size >> 1) {
            T t = this._tail;
            for (int i = this._size - 1; i > n; --i) {
                t = t.getPrevious();
            }
            return t;
        }
        T t = this._head;
        for (int i = 0; i < n; ++i) {
            t = t.getNext();
        }
        return t;
    }

    @Override
    public T getFirst() {
        return this._head;
    }

    @Override
    public T getLast() {
        return this._tail;
    }

    public T getNext(T t) {
        return t.getNext();
    }

    public T getPrevious(T t) {
        return t.getPrevious();
    }

    @Override
    public T removeFirst() {
        T t = this._head;
        if (t == null) {
            return null;
        }
        Object object = t.getNext();
        t.setNext(null);
        if (null != object) {
            object.setPrevious(null);
        }
        this._head = object;
        if (--this._size == 0) {
            this._tail = null;
        }
        return t;
    }

    @Override
    public T removeLast() {
        T t = this._tail;
        if (t == null) {
            return null;
        }
        Object object = t.getPrevious();
        t.setPrevious(null);
        if (null != object) {
            object.setNext(null);
        }
        this._tail = object;
        if (--this._size == 0) {
            this._head = null;
        }
        return t;
    }

    protected void insert(int n, T object) {
        if (this._size == 0) {
            this._tail = object;
            this._head = this._tail;
        } else if (n == 0) {
            object.setNext(this._head);
            this._head.setPrevious(object);
            this._head = object;
        } else if (n == this._size) {
            this._tail.setNext(object);
            object.setPrevious(this._tail);
            this._tail = object;
        } else {
            Object object2 = this.get(n);
            T t = object2.getPrevious();
            if (t != null) {
                t.setNext(object);
            }
            object.setPrevious(t);
            object.setNext((Object)object2);
            object2.setPrevious(object);
        }
        ++this._size;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof TLinkable) {
            TLinkable tLinkable = (TLinkable)object;
            Object t = tLinkable.getPrevious();
            Object t2 = tLinkable.getNext();
            if (t2 == null && t == null) {
                if (object != this._head) {
                    return false;
                }
                this._tail = null;
                this._head = null;
            } else if (t2 == null) {
                tLinkable.setPrevious(null);
                t.setNext(null);
                this._tail = t;
            } else if (t == null) {
                tLinkable.setNext(null);
                t2.setPrevious(null);
                this._head = t2;
            } else {
                t.setNext(t2);
                t2.setPrevious(t);
                tLinkable.setNext(null);
                tLinkable.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(T t, T t2) {
        if (t == this._head) {
            this.addFirst(t2);
        } else if (t == null) {
            this.addLast(t2);
        } else {
            T t3 = t.getPrevious();
            t2.setNext(t);
            t3.setNext(t2);
            t2.setPrevious(t3);
            t.setPrevious(t2);
            ++this._size;
        }
    }

    public void addAfter(T t, T t2) {
        if (t == this._tail) {
            this.addLast(t2);
        } else if (t == null) {
            this.addFirst(t2);
        } else {
            T t3 = t.getNext();
            t2.setPrevious(t);
            t2.setNext(t3);
            t.setNext(t2);
            t3.setPrevious(t2);
            ++this._size;
        }
    }

    public boolean forEachValue(TObjectProcedure<T> tObjectProcedure) {
        for (T t = this._head; t != null; t = t.getNext()) {
            boolean bl = tObjectProcedure.execute(t);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this._size);
        objectOutput.writeObject(this._head);
        objectOutput.writeObject(this._tail);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this._size = objectInput.readInt();
        this._head = (TLinkable)objectInput.readObject();
        this._tail = (TLinkable)objectInput.readObject();
    }

    protected final class IteratorImpl
    implements ListIterator<T> {
        private int _nextIndex = 0;
        private T _next;
        private T _lastReturned;

        IteratorImpl(int n) {
            if (n < 0 || n > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = n;
            if (n == 0) {
                this._next = TLinkedList.this._head;
            } else if (n == TLinkedList.this._size) {
                this._next = null;
            } else if (n < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int i = 0; i < n; ++i) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int i = TLinkedList.this._size - 1; i > n; --i) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        @Override
        public final void add(T t) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(t);
            } else {
                TLinkedList.this.addBefore(this._next, t);
            }
        }

        @Override
        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        @Override
        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public final T next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public final T previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            if (this._nextIndex == TLinkedList.this._size) {
                this._next = TLinkedList.this._tail;
                this._lastReturned = this._next;
            } else {
                this._next = this._next.getPrevious();
                this._lastReturned = this._next;
            }
            --this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        @Override
        public final void set(T t) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            this.swap(this._lastReturned, t);
            this._lastReturned = t;
        }

        private void swap(T t, T t2) {
            Object t3 = t.getPrevious();
            Object t4 = t.getNext();
            Object t5 = t2.getPrevious();
            Object t6 = t2.getNext();
            if (t4 == t2) {
                if (t3 != null) {
                    t3.setNext(t2);
                }
                t2.setPrevious(t3);
                t2.setNext(t);
                t.setPrevious(t2);
                t.setNext(t6);
                if (t6 != null) {
                    t6.setPrevious(t);
                }
            } else if (t6 == t) {
                if (t5 != null) {
                    t5.setNext(t2);
                }
                t2.setPrevious(t);
                t2.setNext(t4);
                t.setPrevious(t5);
                t.setNext(t2);
                if (t4 != null) {
                    t4.setPrevious(t2);
                }
            } else {
                t.setNext(t6);
                t.setPrevious(t5);
                if (t5 != null) {
                    t5.setNext(t);
                }
                if (t6 != null) {
                    t6.setPrevious(t);
                }
                t2.setNext(t4);
                t2.setPrevious(t3);
                if (t3 != null) {
                    t3.setNext(t2);
                }
                if (t4 != null) {
                    t4.setPrevious(t2);
                }
            }
            if (TLinkedList.this._head == t) {
                TLinkedList.this._head = t2;
            } else if (TLinkedList.this._head == t2) {
                TLinkedList.this._head = t;
            }
            if (TLinkedList.this._tail == t) {
                TLinkedList.this._tail = t2;
            } else if (TLinkedList.this._tail == t2) {
                TLinkedList.this._tail = t;
            }
            if (this._lastReturned == t) {
                this._lastReturned = t2;
            } else if (this._lastReturned == t2) {
                this._lastReturned = t;
            }
            if (this._next == t) {
                this._next = t2;
            } else if (this._next == t2) {
                this._next = t;
            }
        }
    }
}

