/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.procedure.TLongProcedure;
import java.util.Arrays;

public abstract class TLongHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient long[] _set;
    protected long no_entry_value;
    protected boolean consumeFreeSlot;

    public TLongHash() {
        this.no_entry_value = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0L) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TLongHash(int n) {
        super(n);
        this.no_entry_value = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0L) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TLongHash(int n, float f) {
        super(n, f);
        this.no_entry_value = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0L) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TLongHash(int n, float f, long l) {
        super(n, f);
        this.no_entry_value = l;
        if (l != 0L) {
            Arrays.fill(this._set, l);
        }
    }

    public long getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new long[n2];
        return n2;
    }

    public boolean contains(long l) {
        return this.index(l) >= 0;
    }

    public boolean forEach(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int n) {
        this._set[n] = this.no_entry_value;
        super.removeAt(n);
    }

    protected int index(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int n = byArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        byte by = byArray[n3];
        if (by == 0) {
            return -1;
        }
        if (by == 1 && lArray[n3] == l) {
            return n3;
        }
        return this.indexRehashed(l, n3, n2, by);
    }

    int indexRehashed(long l, int n, int n2, byte by) {
        int n3 = this._set.length;
        int n4 = 1 + n2 % (n3 - 2);
        int n5 = n;
        do {
            if ((n -= n4) < 0) {
                n += n3;
            }
            if ((by = this._states[n]) == 0) {
                return -1;
            }
            if (l != this._set[n] || by == 2) continue;
            return n;
        } while (n != n5);
        return -1;
    }

    protected int insertKey(long l) {
        int n = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n2 = n % this._states.length;
        byte by = this._states[n2];
        this.consumeFreeSlot = false;
        if (by == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(n2, l);
            return n2;
        }
        if (by == 1 && this._set[n2] == l) {
            return -n2 - 1;
        }
        return this.insertKeyRehash(l, n2, n, by);
    }

    int insertKeyRehash(long l, int n, int n2, byte by) {
        int n3 = this._set.length;
        int n4 = 1 + n2 % (n3 - 2);
        int n5 = n;
        int n6 = -1;
        do {
            if (by == 2 && n6 == -1) {
                n6 = n;
            }
            if ((n -= n4) < 0) {
                n += n3;
            }
            if ((by = this._states[n]) == 0) {
                if (n6 != -1) {
                    this.insertKeyAt(n6, l);
                    return n6;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(n, l);
                return n;
            }
            if (by != 1 || this._set[n] != l) continue;
            return -n - 1;
        } while (n != n5);
        if (n6 != -1) {
            this.insertKeyAt(n6, l);
            return n6;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int n, long l) {
        this._set[n] = l;
        this._states[n] = 1;
    }
}

