/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.player;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerInfoUtil {
    private final Logger logger = Logger.getLogger("Minecraft");

    public boolean playerInGroup(PayRankPlugin plugin, World world, String playerName, String groupName) {
        boolean foundGroup = false;
        String[] worldGroupList = plugin.getPermission().getPlayerGroups(world.getName(), playerName);
        foundGroup = this.checkGroups(groupName, worldGroupList);
        if (foundGroup) {
            return foundGroup;
        }
        String nullString = null;
        String[] globalGroupList = plugin.getPermission().getPlayerGroups(nullString, playerName);
        foundGroup = this.checkGroups(groupName, globalGroupList);
        if (foundGroup) {
            return foundGroup;
        }
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("playerInGroup not found: [" + playerName + ", " + groupName + "]");
        }
        return false;
    }

    private boolean checkGroups(String groupName, String[] groupList) {
        String[] stringArray = groupList;
        int n = groupList.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("playerGroup: " + group);
            }
            if (group.equalsIgnoreCase(groupName)) {
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("Matched playerGroup: " + group);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PlayerInfo getPlayerInfo(JavaPlugin plugin, CommandSender sender, String searchPlayer) {
        PlayerInfo playerInfo = null;
        PayRankPlugin payRankPlugin = (PayRankPlugin)plugin;
        Player player = this.getMinecraftPlayer(plugin, sender, searchPlayer);
        if (player != null) {
            playerInfo = new PlayerInfo();
            playerInfo.setPlayer(player);
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Have valid player instance. Checking for available ranks...");
            }
            PayRank currentRank = null;
            PayRank previousRank = null;
            PayRank nextRank = null;
            List<PayRank> ranks = PluginConfig.getInstance().getConfig(PayRanksConfig.class).getPayRanks();
            for (PayRank rank : ranks) {
                if (currentRank != null) {
                    nextRank = rank;
                    if (!PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) break;
                    this.logger.info("Found next rank: " + nextRank.getName());
                    break;
                }
                if (this.playerInGroup(payRankPlugin, playerInfo.getPlayer().getWorld(), playerInfo.getPlayer().getName(), rank.getGroup())) {
                    currentRank = rank;
                    if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                        this.logger.info("Found current rank: " + currentRank.getName());
                    }
                }
                if (currentRank != null) continue;
                previousRank = rank;
            }
            if (previousRank != null && currentRank == null) {
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("No current rank, setting previous rank to null. ");
                }
                previousRank = null;
            }
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                if (previousRank != null) {
                    this.logger.info("Found previous rank: " + previousRank.getName());
                } else {
                    this.logger.info("Did not find previous rank.");
                }
            }
            playerInfo.setPreviousRank(previousRank);
            playerInfo.setCurrentRank(currentRank);
            playerInfo.setNextRank(nextRank);
        }
        return playerInfo;
    }

    private Player getMinecraftPlayer(JavaPlugin plugin, CommandSender sender, String searchPlayer) {
        Player player = plugin.getServer().getPlayer(searchPlayer);
        if (player != null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Found player: " + player.getName());
            }
            return player;
        }
        OfflinePlayer offlinePlayer = plugin.getServer().getOfflinePlayer(searchPlayer);
        if (offlinePlayer != null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player " + offlinePlayer.getName() + " appears to be offline.");
            }
            String playerOfflineSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.error.offlinePlayer.sender");
            playerOfflineSender = playerOfflineSender.replaceAll("<player>", ChatColor.BLUE + offlinePlayer.getName() + ChatColor.RED);
            sender.sendMessage(ChatColor.RED + playerOfflineSender);
        } else {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Could not find find player: " + searchPlayer);
            }
            String cannotFindPlayerSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.error.cannotFindPlayer.sender");
            cannotFindPlayerSender = cannotFindPlayerSender.replaceAll("<player>", ChatColor.BLUE + searchPlayer + ChatColor.RED);
            sender.sendMessage(ChatColor.RED + cannotFindPlayerSender);
        }
        return null;
    }
}

