/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command.util;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.IPayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class MessageUtil {
    public static void sendInvalidPermissionsMessage(CommandSender sender) {
        String invalidPermissions = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.error.invalidPermissions");
        sender.sendMessage(ChatColor.RED + invalidPermissions);
    }

    public static void sendHelpMessage(CommandSender sender, IPayRankCommand command) {
        sender.sendMessage(MessageUtil.formatHelp(command.help()));
    }

    public static void sendAllHelpMessages(PayRankPlugin plugin, CommandSender sender, Map<String, IPayRankCommand> commands, HashSet<PayRankPermissions.PayRankPermission> permissions) {
        String listHeader = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.commands.header");
        listHeader = listHeader.replaceAll("<plugin>", plugin.getPluginName());
        sender.sendMessage(ChatColor.GRAY + listHeader);
        boolean hasCommand = false;
        for (IPayRankCommand payRankCommand : commands.values()) {
            if (!permissions.contains((Object)payRankCommand.getPermission())) continue;
            MessageUtil.sendHelpMessage(sender, payRankCommand);
            hasCommand = true;
        }
        if (!hasCommand) {
            String noneAvailable = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.commands.noneAvailable");
            sender.sendMessage(noneAvailable);
        }
    }

    private static String formatHelp(Help help) {
        String message = ChatColor.GOLD + "payRank " + help.getCommand() + " " + help.getArguments() + ChatColor.WHITE + ": " + help.getDescription();
        return message;
    }
}

