/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.CommandCurrent;
import com.netprogs.minecraft.plugins.payrank.command.CommandDemote;
import com.netprogs.minecraft.plugins.payrank.command.CommandGive;
import com.netprogs.minecraft.plugins.payrank.command.CommandList;
import com.netprogs.minecraft.plugins.payrank.command.CommandPromote;
import com.netprogs.minecraft.plugins.payrank.command.CommandPurchase;
import com.netprogs.minecraft.plugins.payrank.command.CommandReload;
import com.netprogs.minecraft.plugins.payrank.command.CommandRemove;
import com.netprogs.minecraft.plugins.payrank.command.IPayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.command.util.MessageUtil;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class PayRankDispatcher
implements CommandExecutor {
    private final Logger logger = Logger.getLogger("Minecraft");
    private Map<String, IPayRankCommand> commands;
    private PayRankPlugin plugin;

    public PayRankDispatcher(PayRankPlugin plugin) {
        this.plugin = plugin;
        this.createCommandMap();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] arguments) {
        HashSet<PayRankPermissions.PayRankPermission> permissions;
        block10: {
            permissions = PayRankPermissions.getPermissions(this.plugin, sender);
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                StringWriter argumentList = new StringWriter();
                String[] stringArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    argumentList.append(argument);
                    argumentList.append(" ");
                    ++n2;
                }
                this.logger.info("Incoming command: " + argumentList.toString());
            }
            if (arguments.length == 0) {
                throw new ArgumentsMissingException();
            }
            String requestedCommand = arguments[0];
            ArrayList<String> commandArguments = new ArrayList<String>();
            int i = 1;
            while (i < arguments.length) {
                commandArguments.add(arguments[i]);
                ++i;
            }
            if (!this.commands.containsKey(requestedCommand)) break block10;
            IPayRankCommand payRankCommand = this.commands.get(requestedCommand);
            try {
                payRankCommand.run(this.plugin, sender, commandArguments, permissions);
            }
            catch (ArgumentsMissingException exception) {
                MessageUtil.sendHelpMessage(sender, payRankCommand);
            }
            catch (InvalidPermissionsException exception) {
                MessageUtil.sendInvalidPermissionsMessage(sender);
            }
            return true;
        }
        try {
            MessageUtil.sendAllHelpMessages(this.plugin, sender, this.commands, permissions);
        }
        catch (ArgumentsMissingException exception) {
            MessageUtil.sendAllHelpMessages(this.plugin, sender, this.commands, permissions);
        }
        return true;
    }

    private void createCommandMap() {
        this.commands = new HashMap<String, IPayRankCommand>();
        CommandList list = new CommandList();
        this.commands.put(list.getCommandName(), list);
        CommandPurchase purchase = new CommandPurchase();
        this.commands.put(purchase.getCommandName(), purchase);
        CommandPromote promote = new CommandPromote();
        this.commands.put(promote.getCommandName(), promote);
        CommandDemote demote = new CommandDemote();
        this.commands.put(demote.getCommandName(), demote);
        CommandGive give = new CommandGive();
        this.commands.put(give.getCommandName(), give);
        CommandRemove remove = new CommandRemove();
        this.commands.put(remove.getCommandName(), remove);
        CommandCurrent current = new CommandCurrent();
        this.commands.put(current.getCommandName(), current);
        CommandReload reload = new CommandReload();
        this.commands.put(reload.getCommandName(), reload);
    }
}

