/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.command.util.PlayerCommandUtil;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandDemote
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandDemote() {
        super("demote", PayRankPermissions.PayRankPermission.demote);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        if (arguments.size() != 1) {
            throw new ArgumentsMissingException();
        }
        if (!permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.demote permission");
            }
            throw new InvalidPermissionsException();
        }
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Executing demote...");
        }
        String playerName = arguments.get(0);
        PayRank currentRank = null;
        PayRank previousRank = null;
        PlayerInfo playerInfo = this.getPlayerInfoUtil().getPlayerInfo(plugin, sender, playerName);
        if (playerInfo != null) {
            currentRank = playerInfo.getCurrentRank();
            previousRank = playerInfo.getPreviousRank();
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player: " + playerInfo.getPlayer().getName());
                this.logger.info("World: " + playerInfo.getPlayer().getWorld());
                if (currentRank != null) {
                    this.logger.info("Current Rank: " + currentRank.getName());
                } else {
                    this.logger.info("Current Rank: null");
                }
                if (previousRank != null) {
                    this.logger.info("Demoted Rank: " + previousRank.getName());
                } else {
                    this.logger.info("Demoted Rank: null");
                }
            }
            if (previousRank != null && currentRank != null) {
                PlayerCommandUtil.changeRank(plugin, playerInfo.getPlayer().getWorld(), playerInfo.getPlayer().getName(), currentRank, previousRank);
                String demoteCompletedPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.demote.completed.player");
                demoteCompletedPlayer = demoteCompletedPlayer.replaceAll("<rank>", ChatColor.BLUE + previousRank.getName() + ChatColor.GREEN);
                playerInfo.getPlayer().sendMessage(ChatColor.GREEN + demoteCompletedPlayer);
                String demoteCompletedSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.demote.completed.sender");
                demoteCompletedSender = demoteCompletedSender.replaceAll("<rank>", ChatColor.BLUE + previousRank.getName() + ChatColor.GREEN);
                demoteCompletedSender = demoteCompletedSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                sender.sendMessage(ChatColor.GREEN + demoteCompletedSender);
            } else {
                String demoteMinimumSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.demote.lowestRankReached.sender");
                demoteMinimumSender = demoteMinimumSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                sender.sendMessage(ChatColor.GREEN + demoteMinimumSender);
            }
        }
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("<player>");
        String demoteHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.demote.help");
        help.setDescription(demoteHelp);
        return help;
    }
}

