/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandCurrent
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandCurrent() {
        super("current", PayRankPermissions.PayRankPermission.current, PayRankPermissions.PayRankPermission.currentOthers);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        PlayerInfo playerInfo;
        if (arguments.size() > 1) {
            throw new ArgumentsMissingException();
        }
        String searchPlayer = null;
        if (arguments.size() == 0) {
            if (!permissions.contains((Object)this.getPermission())) {
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("Player does not have the payrank.current permission");
                }
                throw new InvalidPermissionsException();
            }
            searchPlayer = sender.getName();
        } else if (arguments.size() == 1) {
            if (!permissions.contains((Object)this.getPermissionOthers())) {
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("Player does not have the payrank.current.others permission");
                }
                throw new InvalidPermissionsException();
            }
            searchPlayer = arguments.get(0);
        }
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Attempting to find current rank...");
            this.logger.info("Search for player: " + searchPlayer);
        }
        if ((playerInfo = this.getPlayerInfoUtil().getPlayerInfo(plugin, sender, searchPlayer)) != null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player: " + playerInfo.getPlayer());
                this.logger.info("World: " + playerInfo.getPlayer().getWorld());
                this.logger.info("Name: " + playerInfo.getPlayer().getName());
                this.logger.info("Current Rank: " + playerInfo.getCurrentRank());
            }
            if (playerInfo.getCurrentRank() != null) {
                if (sender != playerInfo.getPlayer()) {
                    String completedSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.current.completed.sender");
                    completedSender = completedSender.replaceAll("<rank>", ChatColor.BLUE + playerInfo.getCurrentRank().getName() + ChatColor.GREEN);
                    completedSender = completedSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                    sender.sendMessage(ChatColor.GREEN + completedSender);
                } else {
                    String completedPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.current.completed.player");
                    completedPlayer = completedPlayer.replaceAll("<rank>", ChatColor.BLUE + playerInfo.getCurrentRank().getName() + ChatColor.GREEN);
                    sender.sendMessage(ChatColor.GREEN + completedPlayer);
                }
                return;
            }
            String cannotFindRankSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.current.cannotFindRank.sender");
            sender.sendMessage(ChatColor.RED + cannotFindRankSender);
        }
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("[player]");
        String giveHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.current.help");
        help.setDescription(giveHelp);
        return help;
    }
}

