/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.config;

import com.netprogs.minecraft.plugins.payrank.config.Configuration;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.bukkit.craftbukkit.libs.com.google.gson.Gson;
import org.bukkit.craftbukkit.libs.com.google.gson.GsonBuilder;

public abstract class JsonConfiguration<T>
extends Configuration<T> {
    private Gson json;

    protected JsonConfiguration(String configFileName) {
        super(configFileName);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.disableHtmlEscaping();
        builder.serializeNulls();
        this.json = builder.create();
    }

    @Override
    protected synchronized void load() {
        FileInputStream inputStream = null;
        InputStreamReader reader = null;
        try {
            try {
                inputStream = new FileInputStream(this.getConfigFile());
                reader = new InputStreamReader(inputStream);
                this.setDataObject(this.json.fromJson((Reader)reader, this.getClassObject()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected synchronized void save() {
        OutputStreamWriter fstream = null;
        BufferedWriter out = null;
        try {
            try {
                String jsonOutput = this.json.toJson(this.getDataObject());
                fstream = new FileWriter(this.getConfigFile());
                out = new BufferedWriter(fstream);
                out.write(jsonOutput);
                out.close();
                fstream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (fstream != null) {
                        fstream.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

