/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command.util;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfoUtil;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.permission.plugins.Permission_PermissionsBukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public abstract class PlayerCommandUtil {
    private static final Logger logger = Logger.getLogger("Minecraft");

    public static void promote(PayRankPlugin plugin, PlayerInfoUtil playerInfoUtil, CommandSender sender, String playerName, boolean doPurchase) {
        List<PayRank> ranks = PluginConfig.getInstance().getConfig(PayRanksConfig.class).getPayRanks();
        PayRank currentUserRank = null;
        PayRank nextRank = null;
        PlayerInfo playerInfo = playerInfoUtil.getPlayerInfo(plugin, sender, playerName);
        if (playerInfo != null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                logger.info("Sender: " + sender.getName());
                logger.info("Player: " + playerInfo.getPlayer().getName());
                logger.info("World: " + playerInfo.getPlayer().getWorld());
            }
            currentUserRank = playerInfo.getCurrentRank();
            nextRank = playerInfo.getNextRank();
            if (nextRank == null && currentUserRank == null) {
                nextRank = ranks.get(0);
            }
            if (nextRank == null) {
                if (doPurchase) {
                    String highestRankPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.highestRankReached.player");
                    playerInfo.getPlayer().sendMessage(ChatColor.GOLD + highestRankPlayer);
                } else {
                    String highestRankSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.highestRankReached.sender");
                    highestRankSender = highestRankSender.replaceAll("<player>", playerInfo.getPlayer().getName());
                    sender.sendMessage(ChatColor.GOLD + highestRankSender);
                }
                return;
            }
            if (nextRank != null) {
                String message;
                boolean rankPaidFor = true;
                if (doPurchase) {
                    if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                        logger.info("Attempting to make purchase: " + nextRank.getName() + ", " + nextRank.getPrice() + ", " + nextRank.getExperience());
                    }
                    if (nextRank.getExperience() != 0) {
                        int currentXp = playerInfo.getPlayer().getTotalExperience();
                        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                            logger.info("currentXp: " + currentXp);
                        }
                        if (currentXp >= nextRank.getExperience()) {
                            playerInfo.getPlayer().setTotalExperience(currentXp - nextRank.getExperience());
                            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                                logger.info("updatedXp: " + playerInfo.getPlayer().getTotalExperience());
                            }
                        } else if (playerInfo.getPlayer() != null) {
                            String notEnoughFundsPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.notEnoughFunds.player");
                            notEnoughFundsPlayer = notEnoughFundsPlayer.replaceAll("<price>", ChatColor.BLUE + Double.toString(nextRank.getExperience()) + "xp" + ChatColor.RED);
                            notEnoughFundsPlayer = notEnoughFundsPlayer.replaceAll("<rank>", ChatColor.BLUE + nextRank.getName() + ChatColor.RED);
                            String message2 = ChatColor.RED + notEnoughFundsPlayer;
                            playerInfo.getPlayer().sendMessage(message2);
                            rankPaidFor = false;
                        }
                    }
                    if (nextRank.getPrice() != 0.0) {
                        if (plugin.getEconomy().has(playerInfo.getPlayer().getName(), nextRank.getPrice())) {
                            plugin.getEconomy().withdrawPlayer(playerInfo.getPlayer().getName(), nextRank.getPrice());
                        } else if (playerInfo.getPlayer() != null) {
                            String notEnoughFundsPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.notEnoughFunds.player");
                            notEnoughFundsPlayer = notEnoughFundsPlayer.replaceAll("<price>", ChatColor.BLUE + Double.toString(nextRank.getPrice()) + ChatColor.RED);
                            notEnoughFundsPlayer = notEnoughFundsPlayer.replaceAll("<rank>", ChatColor.BLUE + nextRank.getName() + ChatColor.RED);
                            message = ChatColor.RED + notEnoughFundsPlayer;
                            playerInfo.getPlayer().sendMessage(message);
                            rankPaidFor = false;
                        }
                    }
                }
                if (rankPaidFor) {
                    PlayerCommandUtil.changeRank(plugin, playerInfo.getPlayer().getWorld(), playerInfo.getPlayer().getName(), currentUserRank, nextRank);
                    if (playerInfo.getPlayer() != null) {
                        String completedPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.completed.player");
                        completedPlayer = completedPlayer.replaceAll("<rank>", ChatColor.BLUE + nextRank.getName() + ChatColor.GREEN);
                        message = ChatColor.GREEN + completedPlayer;
                        playerInfo.getPlayer().sendMessage(message);
                    }
                    if (sender != playerInfo.getPlayer()) {
                        String completedSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.promote.completed.sender");
                        completedSender = completedSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                        completedSender = completedSender.replaceAll("<rank>", ChatColor.BLUE + nextRank.getName() + ChatColor.GREEN);
                        sender.sendMessage(ChatColor.GREEN + completedSender);
                    }
                }
            }
        }
    }

    public static void removeRank(PayRankPlugin plugin, World world, String playerName, PayRank currentRank) {
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            logger.info("Removing rank: " + currentRank.getName());
        }
        if (plugin.getPermission() instanceof Permission_PermissionsBukkit) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                logger.info("Permission_PermissionsBukkit adjustment called.");
            }
            String nullString = null;
            plugin.getPermission().playerRemoveGroup(nullString, playerName, currentRank.getGroup());
        } else {
            plugin.getPermission().playerRemoveGroup(world, playerName, currentRank.getGroup());
        }
    }

    public static void changeRank(PayRankPlugin plugin, World world, String playerName, PayRank currentRank, PayRank newRank) {
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            if (currentRank != null) {
                logger.info("Changing rank from: " + currentRank.getName() + " to " + newRank.getName());
            } else {
                logger.info("Assigning new rank: " + newRank.getName());
            }
        }
        if (plugin.getPermission() instanceof Permission_PermissionsBukkit) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                logger.info("Permission_PermissionsBukkit adjustment called.");
            }
            String nullString = null;
            plugin.getPermission().playerAddGroup(nullString, playerName, newRank.getGroup());
            if (currentRank != null) {
                plugin.getPermission().playerRemoveGroup(nullString, playerName, currentRank.getGroup());
            }
        } else {
            plugin.getPermission().playerAddGroup(world, playerName, newRank.getGroup());
            if (currentRank != null) {
                plugin.getPermission().playerRemoveGroup(world, playerName, currentRank.getGroup());
            }
        }
    }
}

