/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import java.util.HashSet;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PayRankPermissions {
    private static final Logger logger = Logger.getLogger("Minecraft");

    public static HashSet<PayRankPermission> getPermissions(PayRankPlugin plugin, CommandSender sender) {
        HashSet<PayRankPermission> permissions = new HashSet<PayRankPermission>();
        if (sender instanceof ConsoleCommandSender) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                logger.info("Setting console permissions...");
            }
            permissions.add(PayRankPermission.promote);
            permissions.add(PayRankPermission.demote);
            permissions.add(PayRankPermission.give);
            permissions.add(PayRankPermission.remove);
            permissions.add(PayRankPermission.current);
            permissions.add(PayRankPermission.currentOthers);
            permissions.add(PayRankPermission.reload);
            permissions.add(PayRankPermission.list);
        } else if (sender instanceof Player) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                logger.info("Setting player permissions...");
            }
            Player player = (Player)sender;
            PayRankPermission[] payRankPermissionArray = PayRankPermission.values();
            int n = payRankPermissionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PayRankPermission permission = payRankPermissionArray[n2];
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    logger.info("Checking: payrank." + permission.toString());
                }
                if (plugin.getPermission().has(player, "payrank." + permission.toString())) {
                    if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                        logger.info("Matched: payrank." + permission.toString());
                    }
                    permissions.add(permission);
                }
                ++n2;
            }
        }
        return permissions;
    }

    public static enum PayRankPermission {
        currentOthers{

            public String toString() {
                return "current.others";
            }
        }
        ,
        reload,
        purchase,
        promote,
        demote,
        give,
        remove,
        current,
        list;

    }
}

