/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.command.util.PlayerCommandUtil;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPurchase
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandPurchase() {
        super("purchase", PayRankPermissions.PayRankPermission.purchase);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        if (permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Executing purchase...");
            }
        } else {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.purchase permission");
            }
            throw new InvalidPermissionsException();
        }
        Player player = (Player)sender;
        PlayerCommandUtil.promote(plugin, this.getPlayerInfoUtil(), sender, player.getName(), true);
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("");
        String purchaseHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.purchase.help");
        help.setDescription(purchaseHelp);
        return help;
    }
}

