/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.command.util.PlayerCommandUtil;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandGive
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandGive() {
        super("give", PayRankPermissions.PayRankPermission.give);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        PlayerInfo playerInfo;
        if (arguments.size() != 2) {
            throw new ArgumentsMissingException();
        }
        if (!permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.give permission");
            }
            throw new InvalidPermissionsException();
        }
        String searchPlayer = arguments.get(0);
        String searchRank = arguments.get(1);
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Search for player: " + searchPlayer);
            this.logger.info("Search for rank: " + searchRank);
        }
        if ((playerInfo = this.getPlayerInfoUtil().getPlayerInfo(plugin, sender, searchPlayer)) != null) {
            PayRank giveRank = PluginConfig.getInstance().getConfig(PayRanksConfig.class).getPayRankMatching(searchRank);
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player: " + playerInfo.getPlayer());
                this.logger.info("World: " + playerInfo.getPlayer().getWorld());
                this.logger.info("Name: " + playerInfo.getPlayer().getName());
                if (playerInfo.getPreviousRank() != null) {
                    this.logger.info("Previous Rank: " + playerInfo.getPreviousRank().getName());
                } else {
                    this.logger.info("Previous Rank: null");
                }
                if (playerInfo.getCurrentRank() != null) {
                    this.logger.info("Current Rank: " + playerInfo.getCurrentRank().getName());
                } else {
                    this.logger.info("Previous Rank: null");
                }
                if (playerInfo.getNextRank() != null) {
                    this.logger.info("Next Rank: " + playerInfo.getNextRank().getName());
                } else {
                    this.logger.info("Previous Rank: null");
                }
            }
            if (giveRank == playerInfo.getCurrentRank()) {
                String alreadyHasRankSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.give.alreadyHasRank.sender");
                alreadyHasRankSender = alreadyHasRankSender.replaceAll("<rank>", ChatColor.BLUE + giveRank.getName() + ChatColor.RED);
                sender.sendMessage(ChatColor.RED + alreadyHasRankSender);
                return;
            }
            if (giveRank != null) {
                PlayerCommandUtil.changeRank(plugin, playerInfo.getPlayer().getWorld(), playerInfo.getPlayer().getName(), playerInfo.getCurrentRank(), giveRank);
                String completedSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.give.completed.sender");
                completedSender = completedSender.replaceAll("<rank>", ChatColor.BLUE + giveRank.getName() + ChatColor.GREEN);
                completedSender = completedSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                sender.sendMessage(ChatColor.GREEN + completedSender);
                if (playerInfo.getPlayer() != null) {
                    String completedPlayer = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.give.completed.player");
                    completedPlayer = completedPlayer.replaceAll("<rank>", ChatColor.BLUE + giveRank.getName() + ChatColor.GREEN);
                    String message = ChatColor.GREEN + completedPlayer;
                    playerInfo.getPlayer().sendMessage(message);
                }
            } else {
                String cannotFindRankSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.give.cannotFindRank.sender");
                cannotFindRankSender = cannotFindRankSender.replaceAll("<rank>", ChatColor.BLUE + searchRank + ChatColor.RED);
                sender.sendMessage(ChatColor.RED + cannotFindRankSender);
            }
        }
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("<player> <rank>");
        String giveHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.give.help");
        help.setDescription(giveHelp);
        return help;
    }
}

