/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank;

import com.netprogs.minecraft.plugins.payrank.Metrics;
import com.netprogs.minecraft.plugins.payrank.command.PayRankDispatcher;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.listener.PlayerChatListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PayRankPlugin
extends JavaPlugin {
    private String pluginName;
    private File pluginFolder;
    private Economy economy = null;
    private Permission permission = null;
    private Metrics metrics;

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.pluginName = this.getDescription().getName();
        this.pluginFolder = this.getDataFolder();
        this.setupEconomy();
        this.setupPermission();
        this.loadConfigurations();
        this.getCommand("payRank").setExecutor((CommandExecutor)new PayRankDispatcher(this));
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isChatFormattingEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        }
        try {
            this.metrics = new Metrics((Plugin)this);
            this.metrics.start();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Error while enabling Metrics.");
        }
        this.getLogger().info("Enabled v" + pdfFile.getVersion());
    }

    public void loadConfigurations() {
        PluginConfig.getInstance().reset();
        PluginConfig.getInstance().register(new SettingsConfig(this.getDataFolder() + "/config.json"));
        PluginConfig.getInstance().register(new PayRanksConfig(this.getDataFolder() + "/payranks.json"));
        PluginConfig.getInstance().register(new ResourcesConfig(this.getDataFolder() + "/resources.json"));
    }

    private void setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
    }

    public void setupPermission() {
        RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permission = (Permission)permissionProvider.getProvider();
        }
    }

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info("Disabled v" + pdfFile.getVersion());
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }
}

