/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.listener;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRankTemplate;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRankWorld;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfoUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PlayerChatListener
implements Listener {
    private final Logger logger = Logger.getLogger("Minecraft");
    private PlayerInfoUtil playerInfoUtil = new PlayerInfoUtil();
    private PayRankPlugin plugin;

    public PlayerChatListener(PayRankPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChatEvent(AsyncPlayerChatEvent event) {
        PlayerInfo playerInfo;
        Player player = event.getPlayer();
        World world = event.getPlayer().getWorld();
        PayRank currentUserRank = null;
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Searching for player current PayRank: " + player.getName());
        }
        if ((playerInfo = this.playerInfoUtil.getPlayerInfo(this.plugin, (CommandSender)player, player.getName())) != null) {
            currentUserRank = playerInfo.getCurrentRank();
        }
        if (currentUserRank != null) {
            Map<String, PayRankTemplate> templates;
            PayRankTemplate template;
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Found PayRank: " + currentUserRank.getName() + ", applying chat settings.");
            }
            if ((template = (templates = PluginConfig.getInstance().getConfig(PayRanksConfig.class).getTemplates()).get(currentUserRank.getTemplate())) != null) {
                Map<String, PayRankWorld> worldMap = template.getWorldMap();
                String message = event.getMessage().replaceAll("%", "%%");
                String format = template.getFormat();
                String timeFormat = template.getTime();
                if (timeFormat != null && !timeFormat.equalsIgnoreCase("")) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(timeFormat);
                    Calendar calendar = Calendar.getInstance();
                    format = format.replaceAll("\\[time\\]", String.valueOf(dateFormat.format(calendar.getTime())));
                } else {
                    String space = "";
                    if (format.contains("[time] ")) {
                        space = " ";
                    }
                    format = format.replaceAll("\\[time\\]" + space, "");
                }
                PayRankWorld payRankWorld = worldMap.get(world.getName());
                if (payRankWorld != null) {
                    format = format.replaceAll("\\[world\\]", payRankWorld.getDisplayName());
                }
                format = format.replaceAll("\\[prefix\\]", currentUserRank.getPrefix());
                format = format.replaceAll("\\[suffix\\]", currentUserRank.getSuffix());
                format = format.replaceAll("\\[player\\]", player.getDisplayName());
                format = format.replaceAll("(&([A-Fa-f0-9L-Ol-o]))", "\u00a7$2");
                event.setFormat(String.valueOf(format) + message);
            }
        } else if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Could not find a current PayRank: " + player.getName() + ". Using default chat settings.");
        }
    }
}

