/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.config;

import com.netprogs.minecraft.plugins.payrank.config.JsonConfiguration;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRankTemplate;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRanks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PayRanksConfig
extends JsonConfiguration<PayRanks> {
    private final Logger logger = Logger.getLogger("Minecraft");
    private List<PayRank> payRankList = null;
    private Map<String, PayRank> payRankNameMap = null;
    private Map<String, PayRank> payRankGroupMap = null;
    private Map<String, PayRankTemplate> templateMap = null;

    public PayRanksConfig(String configFileName) {
        super(configFileName);
    }

    public List<PayRank> getPayRanks() {
        this.getPayRankData();
        return this.payRankList;
    }

    public PayRank getPayRankMatching(String rankName) {
        this.getPayRankData();
        PayRank value = this.payRankNameMap.get(rankName);
        if (value == null) {
            return this.payRankGroupMap.get(rankName);
        }
        return value;
    }

    public PayRank getPayRankByGroup(String rankGroup) {
        this.getPayRankData();
        return this.payRankGroupMap.get(rankGroup);
    }

    private void getPayRankData() {
        if (this.payRankList == null || this.payRankNameMap == null || this.payRankGroupMap == null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Initializing PayRank data...");
            }
            List<PayRank> ranks = ((PayRanks)this.getDataObject()).getPayRanks();
            this.payRankList = new ArrayList<PayRank>();
            this.payRankNameMap = new HashMap<String, PayRank>();
            this.payRankGroupMap = new HashMap<String, PayRank>();
            for (PayRank rank : ranks) {
                if (rank == null) continue;
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("Adding rank: " + rank.getName());
                }
                this.payRankNameMap.put(rank.getName(), rank);
                this.payRankGroupMap.put(rank.getGroup(), rank);
                this.payRankList.add(rank);
            }
        }
    }

    public Map<String, PayRankTemplate> getTemplates() {
        if (this.templateMap == null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Initializing template data...");
            }
            List<PayRankTemplate> templates = ((PayRanks)this.getDataObject()).getTemplates();
            this.templateMap = new HashMap<String, PayRankTemplate>();
            for (PayRankTemplate template : templates) {
                if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                    this.logger.info("Adding template: " + template.getName());
                }
                this.templateMap.put(template.getName(), template);
            }
        }
        return this.templateMap;
    }
}

