/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;

public abstract class Configuration<T> {
    private boolean firstRun;
    private boolean copyDefaults;
    private File configFile;
    private Class<T> classObject;
    private T dataObject;
    private T defaultDataObject;

    private void createClassObject() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.classObject = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    protected Configuration(String configFileName) {
        this.createClassObject();
        this.defaultDataObject = null;
        this.configFile = new File(configFileName);
        this.firstRun = false;
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.firstRun = true;
        }
    }

    public final void loadConfig() {
        this.extractConfiguration();
        this.preLoad();
        this.load();
        this.postLoad();
    }

    public final void saveConfig() {
        this.preSave();
        this.save();
        this.postSave();
    }

    private void extractConfiguration() {
        if (this.isFirstRun() && this.getCopyDefaults()) {
            try {
                this.configFile.createNewFile();
                this.setDataObject(this.defaultDataObject);
                this.saveConfig();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (this.isFirstRun()) {
            this.extractFromJar();
        }
    }

    protected void preLoad() {
    }

    protected abstract void load();

    protected void postLoad() {
        this.firstRun = false;
    }

    protected void preSave() {
    }

    protected abstract void save();

    protected void postSave() {
    }

    public final void reloadConfig() {
        try {
            this.setDataObject(null);
            this.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setDataObject(T dataObject) {
        this.dataObject = dataObject;
    }

    protected T getDataObject() {
        return this.dataObject;
    }

    private void extractFromJar() {
        try {
            int c;
            InputStream inputStream = this.classObject.getClassLoader().getResourceAsStream(this.configFile.getName());
            FileWriter outputStream = new FileWriter(this.configFile);
            while ((c = inputStream.read()) != -1) {
                outputStream.write(c);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class<T> getClassObject() {
        return this.classObject;
    }

    protected File getConfigFile() {
        return this.configFile;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public void setDefaultDataObject(T defaultDataObject) {
        this.defaultDataObject = defaultDataObject;
    }

    public boolean getCopyDefaults() {
        return this.copyDefaults;
    }

    public void setCopyDefaults(boolean copyDefaults) {
        this.copyDefaults = copyDefaults;
    }
}

