/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.command.util.PlayerCommandUtil;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.player.PlayerInfo;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandRemove
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandRemove() {
        super("remove", PayRankPermissions.PayRankPermission.remove);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        PlayerInfo playerInfo;
        if (arguments.size() != 1) {
            throw new ArgumentsMissingException();
        }
        if (!permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.remove permission");
            }
            throw new InvalidPermissionsException();
        }
        String searchPlayer = arguments.get(0);
        if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
            this.logger.info("Attempting to remove current rank...");
            this.logger.info("Search for player: " + searchPlayer);
        }
        if ((playerInfo = this.getPlayerInfoUtil().getPlayerInfo(plugin, sender, searchPlayer)) != null) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player: " + playerInfo.getPlayer());
                this.logger.info("World: " + playerInfo.getPlayer().getWorld());
                this.logger.info("Name: " + playerInfo.getPlayer().getName());
                this.logger.info("Current Rank: " + playerInfo.getCurrentRank());
            }
            if (playerInfo.getCurrentRank() != null) {
                PlayerCommandUtil.removeRank(plugin, playerInfo.getPlayer().getWorld(), playerInfo.getPlayer().getName(), playerInfo.getCurrentRank());
                String removeCompletedSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.remove.completed.sender");
                removeCompletedSender = removeCompletedSender.replaceAll("<player>", ChatColor.AQUA + playerInfo.getPlayer().getName() + ChatColor.GREEN);
                sender.sendMessage(ChatColor.GREEN + removeCompletedSender);
                return;
            }
            String cannotFindRankSender = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.remove.cannotFindRank.sender");
            sender.sendMessage(ChatColor.RED + cannotFindRankSender);
        }
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("<player>");
        String giveHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.remove.help");
        help.setDescription(giveHelp);
        return help;
    }
}

