/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandReload
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandReload() {
        super("reload", PayRankPermissions.PayRankPermission.reload);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        if (arguments.size() != 0) {
            throw new ArgumentsMissingException();
        }
        if (!permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.reload permission");
            }
            throw new InvalidPermissionsException();
        }
        plugin.loadConfigurations();
        String completedMessage = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.reload.completed.sender");
        sender.sendMessage(ChatColor.GREEN + completedMessage);
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("");
        String giveHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.reload.help");
        help.setDescription(giveHelp);
        return help;
    }
}

