/*
 * Decompiled with CFR 0.152.
 */
package com.netprogs.minecraft.plugins.payrank.command;

import com.netprogs.minecraft.plugins.payrank.PayRankPlugin;
import com.netprogs.minecraft.plugins.payrank.command.PayRankCommand;
import com.netprogs.minecraft.plugins.payrank.command.PayRankPermissions;
import com.netprogs.minecraft.plugins.payrank.command.data.Help;
import com.netprogs.minecraft.plugins.payrank.command.exception.ArgumentsMissingException;
import com.netprogs.minecraft.plugins.payrank.command.exception.InvalidPermissionsException;
import com.netprogs.minecraft.plugins.payrank.config.PayRanksConfig;
import com.netprogs.minecraft.plugins.payrank.config.PluginConfig;
import com.netprogs.minecraft.plugins.payrank.config.ResourcesConfig;
import com.netprogs.minecraft.plugins.payrank.config.SettingsConfig;
import com.netprogs.minecraft.plugins.payrank.config.data.PayRank;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandList
extends PayRankCommand {
    private final Logger logger = Logger.getLogger("Minecraft");

    public CommandList() {
        super("list", PayRankPermissions.PayRankPermission.list);
    }

    @Override
    public void run(PayRankPlugin plugin, CommandSender sender, List<String> arguments, HashSet<PayRankPermissions.PayRankPermission> permissions) throws ArgumentsMissingException, InvalidPermissionsException {
        if (!permissions.contains((Object)this.getPermission())) {
            if (PluginConfig.getInstance().getConfig(SettingsConfig.class).isLoggingDebug()) {
                this.logger.info("Player does not have the payrank.list permission");
            }
            throw new InvalidPermissionsException();
        }
        List<PayRank> ranks = PluginConfig.getInstance().getConfig(PayRanksConfig.class).getPayRanks();
        String listHeader = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.list.header");
        listHeader = listHeader.replaceAll("<plugin>", plugin.getPluginName());
        sender.sendMessage(ChatColor.AQUA + listHeader);
        PayRank currentPlayerRank = null;
        if (sender instanceof Player) {
            for (PayRank rank : ranks) {
                Player player = (Player)sender;
                if (!this.getPlayerInfoUtil().playerInGroup(plugin, player.getLocation().getWorld(), sender.getName(), rank.getGroup())) continue;
                currentPlayerRank = rank;
            }
        }
        for (PayRank rank : ranks) {
            ChatColor color = ChatColor.WHITE;
            color = currentPlayerRank == rank ? ChatColor.GREEN : ChatColor.GRAY;
            String cost = ": ";
            String price = "";
            if (rank.getPrice() != 0.0) {
                price = String.valueOf(price) + "$" + rank.getPrice();
                if (rank.getExperience() != 0) {
                    price = String.valueOf(price) + ", ";
                }
            }
            if (rank.getExperience() != 0) {
                price = String.valueOf(price) + rank.getExperience() + "xp";
            }
            if (StringUtils.isEmpty((String)price)) {
                price = "$0, 0xp";
            }
            cost = String.valueOf(cost) + price;
            sender.sendMessage(color + rank.getName() + cost);
        }
    }

    @Override
    public Help help() {
        Help help = new Help();
        help.setCommand(this.getCommandName());
        help.setArguments("");
        String giveHelp = PluginConfig.getInstance().getConfig(ResourcesConfig.class).getResource("payrank.list.help");
        help.setDescription(giveHelp);
        return help;
    }
}

