/*
 * Decompiled with CFR 0.152.
 */
package com.github.dayzminecraft.dayzminecraft.common;

import com.github.dayzminecraft.dayzminecraft.DayZ;
import com.github.dayzminecraft.dayzminecraft.common.blocks.ModBlocks;
import com.github.dayzminecraft.dayzminecraft.common.effects.Effect;
import com.github.dayzminecraft.dayzminecraft.common.entities.EntityBullet;
import com.github.dayzminecraft.dayzminecraft.common.entities.EntityCrawler;
import com.github.dayzminecraft.dayzminecraft.common.entities.EntityZombieDayZ;
import com.github.dayzminecraft.dayzminecraft.common.items.ModItems;
import com.github.dayzminecraft.dayzminecraft.common.misc.ChatHandler;
import com.github.dayzminecraft.dayzminecraft.common.misc.Config;
import com.github.dayzminecraft.dayzminecraft.common.misc.DamageType;
import com.github.dayzminecraft.dayzminecraft.common.misc.LootManager;
import com.github.dayzminecraft.dayzminecraft.common.thirst.PlayerData;
import com.github.dayzminecraft.dayzminecraft.common.world.WorldTypes;
import com.github.dayzminecraft.dayzminecraft.common.world.biomes.Biomes;
import com.github.dayzminecraft.dayzminecraft.common.world.generation.StructureHandler;
import com.github.dayzminecraft.dayzminecraft.common.world.genlayer.GenLayerDayZ;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CommonProxy {
    public void preload(FMLPreInitializationEvent event) {
        ChatHandler.log = Logger.getLogger(DayZ.meta.modId);
        MinecraftForge.EVENT_BUS.register((Object)DayZ.proxy);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)DayZ.proxy);
        Config.init(event);
        ModBlocks.loadBlocks();
        ModItems.loadItems();
        Biomes.loadBiomes();
        Biomes.addVillages();
        WorldTypes.loadWorldTypes();
        Effect.loadEffects();
        StructureHandler.addDefaultStructures();
        Effect.register();
        EntityRegistry.registerGlobalEntityID(EntityZombieDayZ.class, (String)"Walker", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)1, (int)2);
        EntityRegistry.registerGlobalEntityID(EntityCrawler.class, (String)"Crawler", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)1, (int)2);
        EntityRegistry.registerModEntity(EntityBullet.class, (String)"Bullet", (int)1, (Object)DayZ.INSTANCE, (int)250, (int)5, (boolean)true);
        EntityRegistry.addSpawn(EntityZombieDayZ.class, (int)200, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{Biomes.biomeForest, Biomes.biomePlains, Biomes.biomeRiver, Biomes.biomeSnowMountains, Biomes.biomeSnowPlains});
        EntityRegistry.addSpawn(EntityCrawler.class, (int)100, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{Biomes.biomeForest, Biomes.biomePlains, Biomes.biomeRiver, Biomes.biomeSnowMountains, Biomes.biomeSnowPlains});
    }

    public void load(FMLInitializationEvent event) {
    }

    public void postload(FMLPostInitializationEvent event) {
        LootManager.init();
    }

    public void serverStarted(FMLServerStartedEvent event) {
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        for (Object obj : event.world.field_147482_g) {
            if (!(obj instanceof TileEntityChest)) continue;
            TileEntityChest chest = (TileEntityChest)obj;
            if (event.world.func_147439_a(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e) != ModBlocks.chestLoot) continue;
            boolean continueChecking = true;
            int slotNumber = 0;
            while (continueChecking) {
                if (chest.func_70301_a(slotNumber) == null && slotNumber < 27) {
                    if (slotNumber == 26) {
                        WeightedRandomChestContent.func_76293_a((Random)event.world.field_73012_v, (WeightedRandomChestContent[])LootManager.loot, (IInventory)chest, (int)(event.world.field_73012_v.nextInt(5) + 1));
                        ChatHandler.logDebug("Refilled chest at " + chest.field_145851_c + ", " + chest.field_145848_d + ", " + chest.field_145849_e + ".");
                        continueChecking = false;
                        continue;
                    }
                    ++slotNumber;
                    continue;
                }
                continueChecking = false;
            }
        }
    }

    @SubscribeEvent
    public void playerInteract(EntityInteractEvent event) {
        if (event.target != null && event.target instanceof EntityPlayer && event.entityPlayer.func_71045_bC().func_77973_b().equals(ModItems.healBloodbag)) {
            ((EntityPlayer)event.target).func_70691_i(20.0f);
            --event.entityPlayer.func_71045_bC().field_77994_a;
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer && DayZ.isServer()) {
            PlayerData.get((EntityPlayer)event.entityLiving).handleThirst();
        }
        if (event.entityLiving.func_70644_a((Potion)Effect.bleeding)) {
            if (event.entityLiving.func_70660_b((Potion)Effect.bleeding).func_76459_b() == 0) {
                event.entityLiving.func_82170_o(Effect.bleeding.field_76415_H);
                return;
            }
            if (event.entityLiving.field_70170_p.field_73012_v.nextInt(100) == 0) {
                event.entityLiving.func_70097_a(DamageType.bleedOut, 2.0f);
            }
        }
        if (event.entityLiving.func_70644_a((Potion)Effect.zombification)) {
            if (event.entityLiving.func_70660_b((Potion)Effect.zombification).func_76459_b() == 0) {
                event.entityLiving.func_82170_o(Effect.zombification.field_76415_H);
                return;
            }
            if (event.entityLiving.field_70170_p.field_73012_v.nextInt(100) == 0) {
                if (event.entityLiving.func_110143_aJ() > 1.0f) {
                    event.entityLiving.func_70097_a(DamageType.zombieInfection, 1.0f);
                } else {
                    EntityZombieDayZ var2 = new EntityZombieDayZ(event.entityLiving.field_70170_p);
                    var2.func_70012_b(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                    event.entityLiving.field_70170_p.func_72838_d((Entity)var2);
                    event.entityLiving.func_70097_a(DamageType.zombieInfection, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && PlayerData.get((EntityPlayer)event.entity) == null) {
            PlayerData.register((EntityPlayer)event.entity);
        }
        if (event.entity instanceof EntityPlayer && event.entity.getExtendedProperties("DayZPlayerData") == null) {
            event.entity.registerExtendedProperties("DayZPlayerData", (IExtendedEntityProperties)new PlayerData((EntityPlayer)event.entity));
        }
    }

    @SubscribeEvent
    public void initBiomeGens(WorldTypeEvent.InitBiomeGens event) {
        if (event.worldType instanceof WorldTypes) {
            event.newBiomeGens = GenLayerDayZ.getGenLayers(event.seed, (WorldTypes)event.worldType);
        }
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Populate event) {
        if (event.world.func_72912_H().func_76067_t() instanceof WorldTypes) {
            if (event.type == PopulateChunkEvent.Populate.EventType.LAKE) {
                event.setResult(Event.Result.DENY);
            }
            if (event.type == PopulateChunkEvent.Populate.EventType.LAVA) {
                event.setResult(Event.Result.DENY);
            }
            if (event.type == PopulateChunkEvent.Populate.EventType.DUNGEON) {
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.world.func_72912_H().func_76067_t() instanceof WorldTypes && event.world.field_73012_v.nextInt(Config.structureGenerationChance) == 0) {
            for (int i = 0; i < 12; ++i) {
                int x = event.chunkX * 16 + event.rand.nextInt(16) + 8;
                int y = event.rand.nextInt(128);
                int z = event.chunkZ * 16 + event.rand.nextInt(16) + 8;
                StructureHandler.generateStructure(event.world, event.rand, x, y, z);
            }
        }
    }
}

