/*
 * Decompiled with CFR 0.152.
 */
package de.cuina.fireandfuel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.mp3spi.DecodedMpegAudioInputStream;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecJLayerMP3
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private Decoder decoder;
    private Bitstream bitstream;
    private DMAISObuffer buffer;
    private Header mainHeader;
    private AudioFormat myAudioFormat = null;
    private DecodedMpegAudioInputStream myAudioInputStream = null;
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    public void reverseByteOrder(boolean b) {
    }

    public boolean initialize(URL url) {
        this.initialized(true, false);
        this.cleanup();
        if (url == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            return false;
        }
        try {
            this.bitstream = new Bitstream(new BufferedInputStream(url.openStream()));
            this.decoder = new Decoder();
            this.mainHeader = this.bitstream.readFrame();
            this.buffer = new DMAISObuffer(2);
            this.decoder.setOutputBuffer(this.buffer);
            int channels = this.mainHeader.mode() < 3 ? 2 : 1;
            this.bitstream.closeFrame();
            this.bitstream.close();
            this.myAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.mainHeader.frequency(), 16, channels, channels * 2, this.mainHeader.frequency(), false);
            AudioFormat mpegAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, channels, channels * 2, -1.0f, false);
            this.myAudioInputStream = new DecodedMpegAudioInputStream(this.myAudioFormat, new AudioInputStream(new BufferedInputStream(url.openStream()), mpegAudioFormat, -1L));
        }
        catch (Exception e) {
            this.errorMessage("Unable to set up input streams in method 'initialize'");
            this.printStackTrace(e);
            this.cleanup();
            return false;
        }
        if (this.myAudioInputStream == null) {
            this.errorMessage("Unable to set up audio input stream in method 'initialize'");
            this.cleanup();
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    public boolean initialized() {
        return this.initialized(false, false);
    }

    public SoundBuffer read() {
        int bytesRead;
        if (this.myAudioInputStream == null) {
            this.endOfStream(true, true);
            return null;
        }
        AudioFormat audioFormat = this.myAudioInputStream.getFormat();
        if (audioFormat == null) {
            this.errorMessage("Audio Format null in method 'read'");
            this.endOfStream(true, true);
            return null;
        }
        int cnt = 0;
        byte[] streamBuffer = new byte[SoundSystemConfig.getStreamingBufferSize()];
        try {
            for (bytesRead = 0; !this.endOfStream(false, false) && bytesRead < streamBuffer.length; bytesRead += cnt) {
                this.myAudioInputStream.execute();
                cnt = this.myAudioInputStream.read(streamBuffer, bytesRead, streamBuffer.length - bytesRead);
                if (cnt > 0) continue;
                this.endOfStream(true, true);
                break;
            }
        }
        catch (IOException ioe) {
            this.endOfStream(true, true);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.endOfStream(true, true);
            return null;
        }
        if (bytesRead <= 0) {
            this.endOfStream(true, true);
            return null;
        }
        SoundBuffer buffer = new SoundBuffer(streamBuffer, audioFormat);
        return buffer;
    }

    public SoundBuffer readAll() {
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        byte[] fullBuffer = null;
        int fileSize = this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8;
        if (fileSize > 0) {
            fullBuffer = new byte[this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8];
            int read = 0;
            try {
                for (int total = 0; (read = this.myAudioInputStream.read(fullBuffer, total, fullBuffer.length - total)) != -1 && total < fullBuffer.length; total += read) {
                }
            }
            catch (IOException e) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #1).");
                this.printStackTrace(e);
                return null;
            }
        }
        int bytesRead = 0;
        int cnt = 0;
        byte[] smallBuffer = null;
        smallBuffer = new byte[SoundSystemConfig.getFileChunkSize()];
        for (int totalBytes = 0; !this.endOfStream(false, false) && totalBytes < SoundSystemConfig.getMaxFileSize(); totalBytes += bytesRead) {
            cnt = 0;
            try {
                for (bytesRead = 0; bytesRead < smallBuffer.length; bytesRead += cnt) {
                    this.myAudioInputStream.execute();
                    cnt = this.myAudioInputStream.read(smallBuffer, bytesRead, smallBuffer.length - bytesRead);
                    if (cnt > 0) continue;
                    this.endOfStream(true, true);
                    break;
                }
            }
            catch (IOException e) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #2).");
                this.printStackTrace(e);
                return null;
            }
            fullBuffer = CodecJLayerMP3.appendByteArrays(fullBuffer, smallBuffer, bytesRead);
        }
        SoundBuffer soundBuffer = new SoundBuffer(fullBuffer, this.myAudioFormat);
        try {
            this.myAudioInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return soundBuffer;
    }

    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    public void cleanup() {
        if (this.myAudioInputStream != null) {
            try {
                this.myAudioInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean action, boolean value) {
        if (action) {
            this.initialized = value;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean action, boolean value) {
        if (action) {
            this.endOfStream = value;
        }
        return this.endOfStream;
    }

    public static void reverseBytes(byte[] buffer) {
        CodecJLayerMP3.reverseBytes(buffer, 0, buffer.length);
    }

    public static void reverseBytes(byte[] buffer, int offset, int size) {
        for (int i = offset; i < offset + size; i += 2) {
            byte b = buffer[i];
            buffer[i] = buffer[i + 1];
            buffer[i + 1] = b;
        }
    }

    private void errorMessage(String message) {
        this.logger.errorMessage("CodecJLayerMP3", message, 0);
    }

    private void printStackTrace(Exception e) {
        this.logger.printStackTrace(e, 1);
    }

    private static byte[] appendByteArrays(byte[] arrayOne, byte[] arrayTwo, int length) {
        byte[] newArray;
        if (arrayOne == null && arrayTwo == null) {
            return null;
        }
        if (arrayOne == null) {
            newArray = new byte[length];
            System.arraycopy(arrayTwo, 0, newArray, 0, length);
            arrayTwo = null;
        } else if (arrayTwo == null) {
            newArray = new byte[arrayOne.length];
            System.arraycopy(arrayOne, 0, newArray, 0, arrayOne.length);
            arrayOne = null;
        } else {
            newArray = new byte[arrayOne.length + length];
            System.arraycopy(arrayOne, 0, newArray, 0, arrayOne.length);
            System.arraycopy(arrayTwo, 0, newArray, arrayOne.length, length);
            arrayOne = null;
            arrayTwo = null;
        }
        return newArray;
    }

    private static class DMAISObuffer
    extends Obuffer {
        private int m_nChannels;
        private byte[] m_abBuffer;
        private int[] m_anBufferPointers;
        private boolean m_bIsBigEndian;

        public DMAISObuffer(int nChannels) {
            this.m_nChannels = nChannels;
            this.m_abBuffer = new byte[2304 * nChannels];
            this.m_anBufferPointers = new int[nChannels];
            this.reset();
        }

        @Override
        public void append(int nChannel, short sValue) {
            byte bSecondByte;
            byte bFirstByte;
            if (this.m_bIsBigEndian) {
                bFirstByte = (byte)(sValue >>> 8 & 0xFF);
                bSecondByte = (byte)(sValue & 0xFF);
            } else {
                bFirstByte = (byte)(sValue & 0xFF);
                bSecondByte = (byte)(sValue >>> 8 & 0xFF);
            }
            this.m_abBuffer[this.m_anBufferPointers[nChannel]] = bFirstByte;
            this.m_abBuffer[this.m_anBufferPointers[nChannel] + 1] = bSecondByte;
            int n = nChannel;
            this.m_anBufferPointers[n] = this.m_anBufferPointers[n] + this.m_nChannels * 2;
        }

        @Override
        public void set_stop_flag() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write_buffer(int nValue) {
        }

        @Override
        public void clear_buffer() {
        }

        public void reset() {
            for (int i = 0; i < this.m_nChannels; ++i) {
                this.m_anBufferPointers[i] = i * 2;
            }
        }
    }
}

